/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan.proto;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.rule.accessor.FactHandleFactory;
import org.drools.reliability.core.StorageManagerFactory;
import org.drools.reliability.core.StoredObject;
import org.drools.reliability.infinispan.InfinispanStorageManager;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.types.protobuf.AnySchema;

public class ProtoStreamStoredObject
implements StoredObject {
    private final Object object;
    private final boolean propagated;
    private final long timestamp;
    private final long duration;
    private final String typeUrl;
    private final AnySchema.Any protoObject;

    public ProtoStreamStoredObject(Object object, boolean propagated) {
        this(object, propagated, -1L, -1L);
    }

    public ProtoStreamStoredObject(Object object, boolean propagated, long timestamp, long duration) {
        byte[] objectBytes;
        this.object = object;
        this.propagated = propagated;
        this.timestamp = timestamp;
        this.duration = duration;
        this.typeUrl = object.getClass().getCanonicalName();
        SerializationContext serializationContext = ((InfinispanStorageManager)StorageManagerFactory.get().getStorageManager()).getSerializationContext();
        try {
            objectBytes = ProtobufUtil.toByteArray((ImmutableSerializationContext)serializationContext, (Object)object);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.protoObject = new AnySchema.Any(this.typeUrl, objectBytes);
    }

    @ProtoFactory
    public ProtoStreamStoredObject(AnySchema.Any protoObject, boolean propagated, long timestamp, long duration) {
        this.propagated = propagated;
        this.timestamp = timestamp;
        this.duration = duration;
        this.protoObject = protoObject;
        this.typeUrl = protoObject.getTypeUrl();
        SerializationContext serializationContext = ((InfinispanStorageManager)StorageManagerFactory.get().getStorageManager()).getSerializationContext();
        try {
            Class<?> type = Class.forName(this.typeUrl);
            this.object = ProtobufUtil.fromByteArray((ImmutableSerializationContext)serializationContext, (byte[])protoObject.getValue(), type);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @ProtoField(value=1, required=true)
    public AnySchema.Any getProtoObject() {
        return this.protoObject;
    }

    @ProtoField(value=2, required=true)
    public boolean isPropagated() {
        return this.propagated;
    }

    @ProtoField(value=3, required=true)
    public long getTimestamp() {
        return this.timestamp;
    }

    @ProtoField(value=4, required=true)
    public long getDuration() {
        return this.duration;
    }

    public boolean isEvent() {
        return this.timestamp >= 0L;
    }

    public Object getObject() {
        return this.object;
    }

    public void repropagate(InternalWorkingMemoryEntryPoint ep) {
        if (this.isEvent()) {
            FactHandleFactory fhFactory = ep.getHandleFactory();
            EventFactHandle eFh = fhFactory.createEventFactHandle(fhFactory.getNextId(), this.object, fhFactory.getNextRecency(), (WorkingMemoryEntryPoint)ep, this.timestamp, this.duration);
            ep.insert((InternalFactHandle)eFh);
        } else {
            ep.insert(this.object);
        }
    }

    public String toString() {
        return "ProtoStreamStoredObject{object=" + this.object + ", propagated=" + this.propagated + ", timestamp=" + this.timestamp + ", duration=" + this.duration + ", typeUrl='" + this.typeUrl + "'}";
    }
}

