/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.drools.reliability.core.ReliabilityConfigurationException;
import org.drools.reliability.core.TestableStorageManager;
import org.drools.util.Config;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface InfinispanStorageManager
extends TestableStorageManager {
    public static final Logger LOG = LoggerFactory.getLogger(InfinispanStorageManager.class);

    public void setRemoteCacheManager(RemoteCacheManager var1);

    public void setEmbeddedCacheManager(DefaultCacheManager var1);

    public ConfigurationBuilder provideAdditionalRemoteConfigurationBuilder();

    public static String[] getAllowedPackages() {
        ArrayList<String> allowList = new ArrayList<String>();
        allowList.add("org.kie.*");
        allowList.add("org.drools.*");
        allowList.add("java.*");
        Config.getOptionalConfig((String)"drools.reliability.storage.infinispan.allowedpackages").ifPresent(additionalPkgs -> Arrays.stream(additionalPkgs.split(",")).forEach(p -> allowList.add(p + ".*")));
        return allowList.toArray(new String[allowList.size()]);
    }

    public static MarshallerType getMarshallerType() {
        return Config.getOptionalConfig((String)"drools.reliability.storage.infinispan.marshaller").map(MarshallerType::valueOf).orElse(MarshallerType.JAVA);
    }

    default public Optional<SerializationContextInitializer> findSerializationContextInitializer() {
        return Config.getOptionalConfig((String)"drools.reliability.storage.infinispan.serialization.context.initializer").map(className -> {
            try {
                return (SerializationContextInitializer)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new ReliabilityConfigurationException((Throwable)e);
            }
        });
    }

    default public SerializationContext getSerializationContext() {
        throw new UnsupportedOperationException();
    }

    default public boolean isProtoStream() {
        return false;
    }

    public static enum MarshallerType {
        JAVA,
        PROTOSTREAM;

    }
}

