/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.h2mvstore;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.Storage;
import org.drools.reliability.core.StorageManager;
import org.drools.reliability.core.TestableStorageManager;
import org.drools.reliability.h2mvstore.H2MVStoreStorage;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2MVStoreStorageManager
implements TestableStorageManager {
    private static final Logger LOG = LoggerFactory.getLogger(H2MVStoreStorageManager.class);
    static final H2MVStoreStorageManager INSTANCE = new H2MVStoreStorageManager();
    public static final String STORE_FILE_NAME = "h2mvstore.db";
    private MVStore mvStore;

    private H2MVStoreStorageManager() {
    }

    public void initStorageManager() {
        LOG.info("Using H2MVStoreStorageManager");
        this.mvStore = MVStore.open((String)STORE_FILE_NAME);
    }

    public <K, V> Storage<K, V> internalGetOrCreateStorageForSession(ReteEvaluator reteEvaluator, String cacheName) {
        MVMap mvMap = this.mvStore.openMap(StorageManager.createStorageId((ReteEvaluator)reteEvaluator, (String)cacheName));
        return H2MVStoreStorage.fromMVMap(mvMap);
    }

    public <K, V> Storage<K, V> getOrCreateSharedStorage(String cacheName) {
        MVMap mvMap = this.mvStore.openMap("shared_" + cacheName);
        return H2MVStoreStorage.fromMVMap(mvMap);
    }

    public void close() {
        this.mvStore.close();
    }

    public void removeStorage(String storageName) {
        this.mvStore.removeMap(storageName);
    }

    public void removeStoragesBySessionId(String sessionId) {
        this.mvStore.getMapNames().stream().filter(mapName -> mapName.startsWith("session_" + sessionId + "_")).forEach(this::removeStorage);
    }

    public void removeAllSessionStorages() {
        this.mvStore.getMapNames().stream().filter(mapName -> mapName.startsWith("session_")).forEach(this::removeStorage);
    }

    public Set<String> getStorageNames() {
        return this.mvStore.getMapNames();
    }

    public void restart() {
        this.mvStore.close();
        this.mvStore = null;
        this.initStorageManager();
    }

    public void restartWithCleanUp() {
        this.mvStore.close();
        this.mvStore = null;
        H2MVStoreStorageManager.cleanUpDatabase();
        this.initStorageManager();
    }

    public boolean isRemote() {
        return false;
    }

    public static void cleanUpDatabase() {
        Path path = Paths.get(STORE_FILE_NAME, new String[0]);
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

