/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import org.drools.core.SessionConfiguration;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.rule.accessor.FactHandleFactory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.reliability.core.ReliableGlobalResolver;
import org.drools.reliability.core.ReliableKieSession;
import org.drools.reliability.core.ReliableNamedEntryPoint;
import org.drools.reliability.core.StorageManager;
import org.drools.reliability.core.StorageManagerFactory;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.conf.PersistedSessionOption;

public class ReliableStatefulKnowledgeSessionImpl
extends StatefulKnowledgeSessionImpl
implements ReliableKieSession {
    public ReliableStatefulKnowledgeSessionImpl() {
    }

    public ReliableStatefulKnowledgeSessionImpl(long id, InternalKnowledgeBase kBase, boolean initInitFactHandle, SessionConfiguration config, Environment environment) {
        super(id, kBase, initInitFactHandle, config, environment);
    }

    public ReliableStatefulKnowledgeSessionImpl(long id, InternalKnowledgeBase kBase, FactHandleFactory handleFactory, long propagationContext, SessionConfiguration config, Environment environment) {
        super(id, kBase, handleFactory, propagationContext, config, environment);
    }

    public void dispose() {
        StorageManagerFactory.get().getStorageManager().removeStoragesBySessionId(String.valueOf(StorageManager.getSessionIdentifier((ReteEvaluator)this)));
        super.dispose();
    }

    public void startOperation(ReteEvaluator.InternalOperationType operationType) {
        super.startOperation(operationType);
        if (operationType == ReteEvaluator.InternalOperationType.FIRE) {
            ((ReliableGlobalResolver)this.getGlobalResolver()).updateStorage();
        }
    }

    public void endOperation(ReteEvaluator.InternalOperationType operationType) {
        super.endOperation(operationType);
        if (operationType == ReteEvaluator.InternalOperationType.FIRE) {
            ((ReliableGlobalResolver)this.getGlobalResolver()).updateStorage();
            if (this.getSessionConfiguration().getPersistedSessionOption().getSafepointStrategy() == PersistedSessionOption.SafepointStrategy.AFTER_FIRE) {
                this.safepoint();
            }
        }
    }

    @Override
    public void safepoint() {
        this.getEntryPoints().stream().map(ReliableNamedEntryPoint.class::cast).forEach(ReliableNamedEntryPoint::safepoint);
    }
}

