/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.core.common.Storage;

public class BatchingStorageDecorator<K, V>
implements Storage<K, V> {
    private final Storage<K, V> storage;
    private final Map<K, V> batchingMap = new HashMap();
    private final Set<K> batchingRemoveSet = new HashSet<K>();

    public BatchingStorageDecorator(Storage<K, V> storage) {
        this.storage = storage;
    }

    public V get(K key) {
        if (this.batchingRemoveSet.contains(key)) {
            return null;
        }
        return (V)(this.batchingMap.containsKey(key) ? this.batchingMap.get(key) : this.storage.get(key));
    }

    public V getOrDefault(K key, V value) {
        if (this.batchingRemoveSet.contains(key)) {
            return value;
        }
        return (V)(this.batchingMap.containsKey(key) ? this.batchingMap.get(key) : this.storage.getOrDefault(key, value));
    }

    public V put(K key, V value) {
        this.batchingRemoveSet.remove(key);
        return this.batchingMap.put(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> otherMap) {
        this.batchingRemoveSet.removeAll(otherMap.keySet());
        this.batchingMap.putAll(otherMap);
    }

    public boolean containsKey(K key) {
        return !this.batchingRemoveSet.contains(key) && (this.batchingMap.containsKey(key) || this.storage.containsKey(key));
    }

    public V remove(K key) {
        this.batchingRemoveSet.add(key);
        return this.batchingMap.remove(key);
    }

    public void clear() {
        this.batchingRemoveSet.clear();
        this.batchingMap.clear();
        this.storage.clear();
    }

    public Collection<V> values() {
        this.flush();
        return this.storage.values();
    }

    public Set<K> keySet() {
        if (this.batchingMap.isEmpty() && this.batchingRemoveSet.isEmpty()) {
            return this.storage.keySet();
        }
        HashSet<K> keys = new HashSet<K>();
        keys.addAll(this.storage.keySet());
        keys.addAll(this.batchingMap.keySet());
        keys.removeAll(this.batchingRemoveSet);
        return keys;
    }

    public int size() {
        return this.storage.size() + this.batchingMap.size() - this.batchingRemoveSet.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean requiresFlush() {
        return true;
    }

    public void flush() {
        this.storage.putAll(this.batchingMap);
        this.batchingMap.clear();
        this.batchingRemoveSet.forEach(arg_0 -> this.storage.remove(arg_0));
        this.batchingRemoveSet.clear();
    }
}

