/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.drools.core.ClockType;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.IdentityObjectStore;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.Storage;
import org.drools.reliability.core.ReliableKieSession;
import org.drools.reliability.core.ReliablePseudoClockScheduler;
import org.drools.reliability.core.SerializableStoredEvent;
import org.drools.reliability.core.SerializableStoredObject;
import org.drools.reliability.core.SimpleReliableObjectStore;
import org.drools.reliability.core.StoredEvent;
import org.drools.reliability.core.StoredObject;
import org.drools.reliability.core.util.ReliabilityUtils;
import org.kie.api.runtime.conf.PersistedSessionOption;

public class SimpleSerializationReliableObjectStore
extends IdentityObjectStore
implements SimpleReliableObjectStore {
    protected transient Storage<Long, StoredObject> storage;
    protected boolean reInitPropagated = false;

    public SimpleSerializationReliableObjectStore() {
        throw new UnsupportedOperationException("This constructor should never be called");
    }

    public SimpleSerializationReliableObjectStore(Storage<Long, StoredObject> storage) {
        this.storage = storage;
    }

    public void addHandle(InternalFactHandle handle, Object object) {
        super.addHandle(handle, object);
        this.putIntoPersistedStorage(handle, handle.hasMatches());
    }

    public void removeHandle(InternalFactHandle handle) {
        this.removeFromPersistedStorage(handle.getObject());
        super.removeHandle(handle);
    }

    @Override
    public List<StoredObject> reInit(InternalWorkingMemory session, InternalWorkingMemoryEntryPoint ep) {
        this.reInitPropagated = true;
        HashMap<Long, StoredObject> propagated = new HashMap<Long, StoredObject>();
        ArrayList<StoredObject> notPropagated = new ArrayList<StoredObject>();
        for (Long factHandleId : this.storage.keySet()) {
            StoredObject storedObject = (StoredObject)this.storage.get((Object)factHandleId);
            if (storedObject.isPropagated()) {
                propagated.put(factHandleId, storedObject);
                continue;
            }
            notPropagated.add(storedObject);
        }
        this.storage.clear();
        if (session.getSessionConfiguration().getClockType() == ClockType.PSEUDO_CLOCK) {
            this.repropagateWithPseudoClock(session, ep, propagated);
        } else {
            this.repropagate(session, ep, propagated);
        }
        this.reInitPropagated = false;
        return notPropagated;
    }

    private void repropagate(InternalWorkingMemory session, InternalWorkingMemoryEntryPoint ep, Map<Long, StoredObject> propagated) {
        HashMap<Long, Long> factHandleIdMap = new HashMap<Long, Long>();
        propagated.forEach((oldFactHandleId, storedObject) -> {
            long newFactHandleId = storedObject.repropagate(ep);
            factHandleIdMap.put(newFactHandleId, (Long)oldFactHandleId);
        });
        this.fireOnlyWhenActivationRemaining(session, factHandleIdMap);
    }

    private void fireOnlyWhenActivationRemaining(InternalWorkingMemory session, Map<Long, Long> factHandleIdMap) {
        if (session.getSessionConfiguration().getPersistedSessionOption().getActivationStrategy() == PersistedSessionOption.ActivationStrategy.ACTIVATION_KEY) {
            Storage<String, Object> activationsStorage = ((ReliableKieSession)session).getActivationsStorage();
            Set activationKeySet = activationsStorage.keySet();
            session.fireAllRules(match -> {
                String activationKey = ReliabilityUtils.getActivationKeyReplacingNewIdWithOldId(match, factHandleIdMap);
                if (activationKeySet.contains(activationKey)) {
                    activationsStorage.remove((Object)activationKey);
                    return true;
                }
                return false;
            });
        } else {
            session.fireAllRules(match -> false);
        }
    }

    private void repropagateWithPseudoClock(InternalWorkingMemory session, InternalWorkingMemoryEntryPoint ep, Map<Long, StoredObject> propagated) {
        ReliablePseudoClockScheduler clock = (ReliablePseudoClockScheduler)session.getSessionClock();
        HashMap<Long, Long> factHandleIdMap = new HashMap<Long, Long>();
        for (Map.Entry<Long, StoredObject> entry : propagated.entrySet()) {
            StoredObject storedObject = entry.getValue();
            if (storedObject.isEvent()) {
                long timestamp;
                StoredEvent storedEvent = (StoredEvent)storedObject;
                long currentTime = clock.getCurrentTime();
                if (currentTime < (timestamp = storedEvent.getTimestamp())) {
                    clock.advanceTime(timestamp - currentTime, TimeUnit.MILLISECONDS);
                }
            }
            long newFactHandleId = storedObject.repropagate(ep);
            factHandleIdMap.put(newFactHandleId, entry.getKey());
        }
        this.fireOnlyWhenActivationRemaining(session, factHandleIdMap);
        long currentTime = clock.getCurrentTime();
        long persistedTime = clock.getPersistedTimer().longValue();
        if (currentTime < persistedTime) {
            clock.advanceTime(persistedTime - currentTime, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void putIntoPersistedStorage(InternalFactHandle handle, boolean propagated) {
        Object object = handle.getObject();
        StoredObject storedObject = this.factHandleToStoredObject(handle, this.reInitPropagated || propagated, object);
        this.storage.put((Object)this.getHandleForObject(object).getId(), (Object)storedObject);
    }

    protected StoredObject factHandleToStoredObject(InternalFactHandle handle, boolean propagated, Object object) {
        return handle.isEvent() ? this.createStoredEvent(propagated, object, ((DefaultEventHandle)handle).getStartTimestamp(), ((DefaultEventHandle)handle).getDuration()) : this.createStoredObject(propagated, object);
    }

    protected StoredObject createStoredObject(boolean propagated, Object object) {
        return new SerializableStoredObject(object, propagated);
    }

    protected StoredEvent createStoredEvent(boolean propagated, Object object, long timestamp, long duration) {
        return new SerializableStoredEvent(object, propagated, timestamp, duration);
    }

    @Override
    public void removeFromPersistedStorage(Object object) {
        InternalFactHandle fh = this.getHandleForObject(object);
        if (fh != null) {
            this.storage.remove((Object)fh.getId());
        }
    }

    @Override
    public void safepoint() {
        if (this.storage.requiresFlush()) {
            this.storage.flush();
        }
    }
}

