/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.util.HashMap;
import java.util.Map;
import org.drools.base.rule.accessor.GlobalResolver;
import org.drools.core.common.Storage;

public class ReliableGlobalResolver
implements GlobalResolver {
    protected final Storage<String, Object> storage;
    protected final Map<String, Object> toBeRefreshed = new HashMap<String, Object>();

    public ReliableGlobalResolver(Storage<String, Object> storage) {
        this.storage = storage;
    }

    public Object resolveGlobal(String identifier) {
        if (this.toBeRefreshed.containsKey(identifier)) {
            return this.toBeRefreshed.get(identifier);
        }
        Object global = this.storage.get((Object)identifier);
        this.toBeRefreshed.put(identifier, global);
        return global;
    }

    public void setGlobal(String identifier, Object value) {
        this.storage.put((Object)identifier, value);
    }

    public void removeGlobal(String identifier) {
        this.storage.remove((Object)identifier);
    }

    public void clear() {
        this.storage.clear();
    }

    public void updateStorage() {
        if (!this.toBeRefreshed.isEmpty()) {
            this.toBeRefreshed.forEach((arg_0, arg_1) -> this.storage.put(arg_0, arg_1));
            this.toBeRefreshed.clear();
        }
    }
}

