/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.Storage;
import org.drools.reliability.core.ReliabilityRuntimeException;
import org.drools.reliability.core.SerializableStoredRefObject;
import org.drools.reliability.core.SimpleSerializationReliableObjectStore;
import org.drools.reliability.core.StoredObject;

public class SimpleSerializationReliableRefObjectStore
extends SimpleSerializationReliableObjectStore {
    private Map<String, Long> uniqueObjectTypesInStore = new HashMap<String, Long>();
    private IdentityHashMap<Object, Long> inverseStorage;

    public SimpleSerializationReliableRefObjectStore(Storage<Long, StoredObject> storage) {
        super(storage);
        this.setInverseStorage(storage);
        if (!storage.isEmpty()) {
            this.updateObjectTypesList();
            this.storage = this.updateObjectReferences(storage);
        }
    }

    private void setInverseStorage(Storage<Long, StoredObject> storage) {
        this.inverseStorage = new IdentityHashMap();
        storage.keySet().forEach(key -> this.inverseStorage.put(((StoredObject)storage.get(key)).getObject(), (Long)key));
    }

    private Storage<Long, StoredObject> updateObjectReferences(Storage<Long, StoredObject> storage) {
        Storage<Long, StoredObject> updateStorage = storage;
        for (Long key : storage.keySet()) {
            updateStorage.put((Object)key, (Object)((SerializableStoredRefObject)storage.get((Object)key)).updateReferencedObjects(storage));
        }
        return updateStorage;
    }

    @Override
    public void putIntoPersistedStorage(InternalFactHandle handle, boolean propagated) {
        Object object = handle.getObject();
        StoredObject storedObject = this.factHandleToStoredObject(handle, this.reInitPropagated || propagated, object);
        this.storage.put((Object)this.getHandleForObject(object).getId(), (Object)this.setReferencedObjects(storedObject));
        this.inverseStorage.put(object, this.getHandleForObject(object).getId());
        this.updateObjectTypesList(object);
    }

    @Override
    public void removeFromPersistedStorage(Object object) {
        super.removeFromPersistedStorage(object);
        this.inverseStorage.remove(object);
        this.updateObjectTypesList(object);
    }

    @Override
    protected StoredObject createStoredObject(boolean propagated, Object object) {
        return new SerializableStoredRefObject(object, propagated);
    }

    private StoredObject setReferencedObjects(StoredObject object) {
        List<Field> referencedObjects = this.getReferencedObjects(object.getObject());
        if (!referencedObjects.isEmpty()) {
            referencedObjects.forEach(field -> {
                field.setAccessible(true);
                Object fieldObject = null;
                try {
                    fieldObject = field.get(object.getObject());
                }
                catch (IllegalAccessException e) {
                    throw new ReliabilityRuntimeException(e);
                }
                Long objectKey = this.fromObjectToFactHandleId(fieldObject);
                if (objectKey != null) {
                    ((SerializableStoredRefObject)object).addReferencedObject(field.getName(), objectKey);
                }
            });
        }
        return object;
    }

    private Long fromObjectToFactHandleId(Object object) {
        return this.inverseStorage.get(object);
    }

    private List<Field> getReferencedObjects(Object object) {
        Field[] fields = object.getClass().getDeclaredFields();
        return Arrays.stream(fields).filter(field -> this.uniqueObjectTypesInStore.containsKey(field.getType().getName())).collect(Collectors.toList());
    }

    private void updateObjectTypesList(Object object) {
        this.uniqueObjectTypesInStore.put(object.getClass().getName(), this.storage.values().stream().filter(sObject -> sObject.getObject().getClass().equals(object.getClass())).count());
        if (this.uniqueObjectTypesInStore.get(object.getClass().getName()) == 0L) {
            this.uniqueObjectTypesInStore.remove(object.getClass().getName());
        }
    }

    private void updateObjectTypesList() {
        HashSet uTypeNames = new HashSet();
        this.storage.values().forEach(sObject -> uTypeNames.add(sObject.getObject().getClass().getName()));
        this.uniqueObjectTypesInStore.putAll(this.storage.values().stream().map(sObject -> sObject.getObject().getClass().getName()).filter(uTypeNames::contains).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())));
    }
}

