/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.SessionConfiguration;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.Storage;
import org.drools.core.phreak.PropagationEntry;
import org.drools.reliability.core.FullReliableObjectStore;
import org.drools.reliability.core.ReliableAgenda;
import org.drools.reliability.core.ReliablePropagationList;
import org.drools.reliability.core.SimpleReliableObjectStore;
import org.drools.reliability.core.StorageManagerFactory;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.conf.PersistedSessionOption;
import org.kie.api.runtime.rule.EntryPoint;

public class ReliableSessionInitializer {
    private static final Map<PersistedSessionOption.PersistenceStrategy, SessionInitializer> initializersMap = Map.of(PersistedSessionOption.PersistenceStrategy.STORES_ONLY, new StoresOnlySessionInitializer(), PersistedSessionOption.PersistenceStrategy.FULL, new FullReliableSessionInitializer());

    public static InternalWorkingMemory initReliableSession(SessionConfiguration sessionConfig, InternalWorkingMemory session) {
        PersistedSessionOption persistedSessionOption = sessionConfig.getPersistedSessionOption();
        return initializersMap.get(persistedSessionOption.getPersistenceStrategy()).init(session, persistedSessionOption);
    }

    static class FullReliableSessionInitializer
    implements SessionInitializer {
        FullReliableSessionInitializer() {
        }

        @Override
        public InternalWorkingMemory init(InternalWorkingMemory session, PersistedSessionOption persistedSessionOption) {
            if (!persistedSessionOption.isNewSession()) {
                this.populateSessionFromStorage(session);
            }
            session.getRuleRuntimeEventSupport().addEventListener((EventListener)((Object)new FullStoreRuntimeEventListener(session)));
            return session;
        }

        private void populateSessionFromStorage(InternalWorkingMemory session) {
            for (EntryPoint ep : session.getEntryPoints()) {
                FullReliableObjectStore store = (FullReliableObjectStore)((WorkingMemoryEntryPoint)ep).getObjectStore();
                store.reInit();
            }
        }

        static class FullStoreRuntimeEventListener
        implements RuleRuntimeEventListener {
            private final Storage<Object, Object> componentsCache;
            private final ReliablePropagationList propagationList;

            FullStoreRuntimeEventListener(InternalWorkingMemory session) {
                this.componentsCache = StorageManagerFactory.get().getStorageManager().getOrCreateStorageForSession((ReteEvaluator)session, "components");
                this.propagationList = (ReliablePropagationList)((ReliableAgenda)session.getAgenda()).getPropagationList();
            }

            public void objectInserted(ObjectInsertedEvent ev) {
                this.componentsCache.put((Object)"PropagationList", (Object)this.propagationList);
            }

            public void objectDeleted(ObjectDeletedEvent ev) {
                this.componentsCache.put((Object)"PropagationList", (Object)this.propagationList);
            }

            public void objectUpdated(ObjectUpdatedEvent ev) {
                this.componentsCache.put((Object)"PropagationList", (Object)this.propagationList);
            }
        }
    }

    static class StoresOnlySessionInitializer
    implements SessionInitializer {
        StoresOnlySessionInitializer() {
        }

        @Override
        public InternalWorkingMemory init(InternalWorkingMemory session, PersistedSessionOption persistedSessionOption) {
            if (!persistedSessionOption.isNewSession()) {
                this.populateSessionFromStorage(session);
            }
            session.setWorkingMemoryActionListener(entry -> this.onWorkingMemoryAction(session, (PropagationEntry)entry));
            session.getRuleRuntimeEventSupport().addEventListener((EventListener)((Object)new SimpleStoreRuntimeEventListener(session)));
            return session;
        }

        private void onWorkingMemoryAction(InternalWorkingMemory session, PropagationEntry entry) {
            InternalFactHandle fh;
            if (entry instanceof PropagationEntry.Insert && (fh = ((PropagationEntry.Insert)entry).getHandle()).isValid()) {
                WorkingMemoryEntryPoint ep = fh.getEntryPoint((ReteEvaluator)session);
                ((SimpleReliableObjectStore)ep.getObjectStore()).putIntoPersistedStorage(fh, true);
            }
        }

        private void populateSessionFromStorage(InternalWorkingMemory session) {
            HashMap<InternalWorkingMemoryEntryPoint, List> notPropagatedByEntryPoint = new HashMap<InternalWorkingMemoryEntryPoint, List>();
            for (EntryPoint ep2 : session.getEntryPoints()) {
                SimpleReliableObjectStore store = (SimpleReliableObjectStore)((WorkingMemoryEntryPoint)ep2).getObjectStore();
                notPropagatedByEntryPoint.put((InternalWorkingMemoryEntryPoint)ep2, store.reInit(session, (InternalWorkingMemoryEntryPoint)ep2));
            }
            notPropagatedByEntryPoint.forEach((ep, objects) -> objects.forEach(obj -> obj.repropagate((InternalWorkingMemoryEntryPoint)ep)));
        }

        static class SimpleStoreRuntimeEventListener
        implements RuleRuntimeEventListener {
            private final InternalWorkingMemory session;

            SimpleStoreRuntimeEventListener(InternalWorkingMemory session) {
                this.session = session;
            }

            public void objectInserted(ObjectInsertedEvent ev) {
            }

            public void objectDeleted(ObjectDeletedEvent ev) {
            }

            public void objectUpdated(ObjectUpdatedEvent ev) {
                InternalFactHandle fh = (InternalFactHandle)ev.getFactHandle();
                SimpleReliableObjectStore store = (SimpleReliableObjectStore)fh.getEntryPoint((ReteEvaluator)this.session).getObjectStore();
                store.putIntoPersistedStorage(fh, false);
            }
        }
    }

    static interface SessionInitializer {
        public InternalWorkingMemory init(InternalWorkingMemory var1, PersistedSessionOption var2);
    }
}

