/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.io.Serializable;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.rule.accessor.FactHandleFactory;
import org.drools.reliability.core.ReliablePseudoClockScheduler;
import org.drools.reliability.core.StoredObject;

public class SerializableStoredObject
implements StoredObject,
Serializable {
    private final Serializable object;
    private final boolean propagated;
    private final long timestamp;
    private final long duration;
    private final long handleId;

    public SerializableStoredObject(Object object, boolean propagated) {
        this(object, propagated, -1L, -1L, -1L);
    }

    public SerializableStoredObject(Object object, boolean propagated, long timestamp, long duration, long handleId) {
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException("Object must be serializable : " + object.getClass().getCanonicalName());
        }
        this.object = (Serializable)object;
        this.propagated = propagated;
        this.timestamp = timestamp;
        this.duration = duration;
        this.handleId = handleId;
    }

    @Override
    public boolean isEvent() {
        return this.timestamp >= 0L;
    }

    @Override
    public boolean isPropagated() {
        return this.propagated;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    public long getHandleId() {
        return this.handleId;
    }

    @Override
    public void repropagate(InternalWorkingMemoryEntryPoint ep) {
        if (this.isEvent()) {
            FactHandleFactory fhFactory = ep.getHandleFactory();
            DefaultEventHandle eFh = fhFactory.createEventFactHandle(fhFactory.getNextId(), (Object)this.object, fhFactory.getNextRecency(), (WorkingMemoryEntryPoint)ep, this.timestamp, this.duration);
            ep.insert((InternalFactHandle)eFh);
            ((ReliablePseudoClockScheduler)ep.getReteEvaluator().getTimerService()).putHandleIdAssociation(this.handleId, eFh);
        } else {
            ep.insert((Object)this.object);
        }
    }

    public String toString() {
        return "StoredObject{object=" + this.object + ", propagated=" + this.propagated + ", timestamp=" + this.timestamp + ", duration=" + this.duration + ", handleId=" + this.handleId + "}";
    }
}

