/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.IdentityObjectStore;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.reliability.core.StoredObject;

public class SimpleReliableObjectStore
extends IdentityObjectStore {
    private final Map<Long, StoredObject> cache;
    private boolean reInitPropagated = false;

    public SimpleReliableObjectStore(Map<Long, StoredObject> cache) {
        this.cache = cache;
    }

    public void addHandle(InternalFactHandle handle, Object object) {
        super.addHandle(handle, object);
        this.putIntoPersistedCache(handle, handle.hasMatches());
    }

    public void removeHandle(InternalFactHandle handle) {
        this.removeFromPersistedCache(handle.getObject());
        super.removeHandle(handle);
    }

    public List<StoredObject> reInit(InternalWorkingMemory session, InternalWorkingMemoryEntryPoint ep) {
        this.reInitPropagated = true;
        ArrayList<StoredObject> propagated = new ArrayList<StoredObject>();
        ArrayList<StoredObject> notPropagated = new ArrayList<StoredObject>();
        for (StoredObject entry : this.cache.values()) {
            if (entry.isPropagated()) {
                propagated.add(entry);
                continue;
            }
            notPropagated.add(entry);
        }
        this.cache.clear();
        propagated.forEach(obj -> obj.repropagate(ep));
        session.fireAllRules(match -> false);
        this.reInitPropagated = false;
        return notPropagated;
    }

    public void putIntoPersistedCache(InternalFactHandle handle, boolean propagated) {
        Object object = handle.getObject();
        StoredObject storedObject = handle.isEvent() ? new StoredObject(object, this.reInitPropagated || propagated, ((EventFactHandle)handle).getStartTimestamp(), ((EventFactHandle)handle).getDuration()) : new StoredObject(object, this.reInitPropagated || propagated);
        this.cache.put(((InternalFactHandle)this.fhMap.get(object)).getId(), storedObject);
    }

    public void removeFromPersistedCache(Object object) {
        InternalFactHandle fh = (InternalFactHandle)this.fhMap.get(object);
        if (fh != null) {
            this.cache.remove(fh.getId());
        }
    }
}

