/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.SessionConfiguration;
import org.drools.core.common.AgendaFactory;
import org.drools.core.common.EntryPointFactory;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.RuleBase;
import org.drools.core.rule.accessor.GlobalResolver;
import org.drools.core.time.TimerService;
import org.drools.kiesession.factory.RuntimeComponentFactoryImpl;
import org.drools.kiesession.factory.WorkingMemoryFactory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.reliability.core.CacheManagerFactory;
import org.drools.reliability.core.ReliableAgendaFactory;
import org.drools.reliability.core.ReliableGlobalResolver;
import org.drools.reliability.core.ReliableNamedEntryPointFactory;
import org.drools.reliability.core.ReliablePhreakWorkingMemoryFactory;
import org.drools.reliability.core.ReliablePseudoClockScheduler;
import org.drools.reliability.core.ReliableSessionInitializer;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.PersistedSessionOption;

public class ReliableRuntimeComponentFactoryImpl
extends RuntimeComponentFactoryImpl {
    private static final AtomicLong RELIABLE_SESSIONS_COUNTER = new AtomicLong(0L);
    private static final String NEXT_SESSION_ID = "nextSessionId";
    private final WorkingMemoryFactory wmFactory = ReliablePhreakWorkingMemoryFactory.getInstance();
    private final AgendaFactory agendaFactory = ReliableAgendaFactory.getInstance();

    public ReliableRuntimeComponentFactoryImpl() {
        ReliableRuntimeComponentFactoryImpl.refreshReliableSessionsCounterUsingCache();
    }

    private static void refreshReliableSessionsCounterUsingCache() {
        Map sessionsCounter = CacheManagerFactory.get().getCacheManager().getOrCreateSharedCache("sessionsCounter");
        if (sessionsCounter.containsKey(NEXT_SESSION_ID)) {
            RELIABLE_SESSIONS_COUNTER.set((Long)sessionsCounter.get(NEXT_SESSION_ID));
        } else {
            sessionsCounter.put(NEXT_SESSION_ID, RELIABLE_SESSIONS_COUNTER.get());
        }
    }

    public EntryPointFactory getEntryPointFactory() {
        return new ReliableNamedEntryPointFactory();
    }

    public InternalWorkingMemory createStatefulSession(RuleBase ruleBase, Environment environment, SessionConfiguration sessionConfig, boolean fromPool) {
        if (!sessionConfig.hasPersistedSessionOption()) {
            return super.createStatefulSession(ruleBase, environment, sessionConfig, fromPool);
        }
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)ruleBase;
        if (fromPool || kbase.getSessionPool() == null) {
            InternalWorkingMemory session = this.wmFactory.createWorkingMemory(RELIABLE_SESSIONS_COUNTER.getAndIncrement(), kbase, sessionConfig, environment);
            this.updateSessionsCounter();
            return this.internalInitSession(kbase, sessionConfig, session);
        }
        return (InternalWorkingMemory)kbase.getSessionPool().newKieSession((KieSessionConfiguration)sessionConfig);
    }

    private void updateSessionsCounter() {
        Map sessionsCounter = CacheManagerFactory.get().getCacheManager().getOrCreateSharedCache("sessionsCounter");
        sessionsCounter.put(NEXT_SESSION_ID, RELIABLE_SESSIONS_COUNTER.get());
    }

    public GlobalResolver createGlobalResolver(ReteEvaluator reteEvaluator, Environment environment) {
        if (!reteEvaluator.getSessionConfiguration().hasPersistedSessionOption()) {
            return super.createGlobalResolver(reteEvaluator, environment);
        }
        return new ReliableGlobalResolver(CacheManagerFactory.get().getCacheManager().getOrCreateCacheForSession(reteEvaluator, "globals"));
    }

    public TimerService createTimerService(ReteEvaluator reteEvaluator) {
        if (!reteEvaluator.getSessionConfiguration().hasPersistedSessionOption()) {
            return super.createTimerService(reteEvaluator);
        }
        return new ReliablePseudoClockScheduler(CacheManagerFactory.get().getCacheManager().getOrCreateCacheForSession(reteEvaluator, "timer"));
    }

    private InternalWorkingMemory internalInitSession(InternalKnowledgeBase kbase, SessionConfiguration sessionConfig, InternalWorkingMemory session) {
        if (sessionConfig.isKeepReference()) {
            kbase.addStatefulSession(session);
        }
        return ReliableSessionInitializer.initReliableSession(sessionConfig, session);
    }

    public AgendaFactory getAgendaFactory(SessionConfiguration sessionConfig) {
        if (!sessionConfig.hasPersistedSessionOption() || sessionConfig.getPersistedSessionOption().getStrategy() == PersistedSessionOption.Strategy.STORES_ONLY) {
            return super.getAgendaFactory(sessionConfig);
        }
        return this.agendaFactory;
    }

    public static void resetCounter() {
        RELIABLE_SESSIONS_COUNTER.set(0L);
    }

    public static void refreshCounterUsingCache() {
        ReliableRuntimeComponentFactoryImpl.refreshReliableSessionsCounterUsingCache();
    }

    public int servicePriority() {
        return 1;
    }
}

