/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.time.impl.PseudoClockScheduler;

public class ReliablePseudoClockScheduler
extends PseudoClockScheduler {
    private final Map<String, Object> cache;

    public ReliablePseudoClockScheduler(Map<String, Object> cache) {
        this.cache = cache;
        this.timer = new AtomicLong((Long)cache.getOrDefault("timer", 0L));
        this.idCounter = new AtomicLong((Long)cache.getOrDefault("idCounter", 0L));
        this.queue = cache.getOrDefault("queue", new PriorityQueue());
    }

    public long advanceTime(long amount, TimeUnit unit) {
        long time = super.advanceTime(amount, unit);
        this.updateCache();
        return time;
    }

    private void updateCache() {
        this.cache.put("timer", this.timer.get());
        this.cache.put("idCounter", this.idCounter.get());
        this.cache.put("queue", this.queue);
    }
}

