/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.util.HashMap;
import java.util.Map;
import org.drools.core.rule.accessor.GlobalResolver;

public class ReliableGlobalResolver
implements GlobalResolver {
    private final Map<String, Object> cache;
    private final Map<String, Object> toBeRefreshed = new HashMap<String, Object>();

    public ReliableGlobalResolver(Map<String, Object> cache) {
        this.cache = cache;
    }

    public Object resolveGlobal(String identifier) {
        if (this.toBeRefreshed.containsKey(identifier)) {
            return this.toBeRefreshed.get(identifier);
        }
        Object global = this.cache.get(identifier);
        this.toBeRefreshed.put(identifier, global);
        return global;
    }

    public void setGlobal(String identifier, Object value) {
        this.cache.put(identifier, value);
    }

    public void removeGlobal(String identifier) {
        this.cache.remove(identifier);
    }

    public void clear() {
        this.cache.clear();
    }

    public void updateCache() {
        if (!this.toBeRefreshed.isEmpty()) {
            this.toBeRefreshed.forEach(this.cache::put);
            this.toBeRefreshed.clear();
        }
    }
}

