/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.util.Map;
import java.util.Set;
import org.drools.core.common.ReteEvaluator;
import org.drools.reliability.core.ReliabilityConfigurationException;
import org.kie.api.runtime.conf.PersistedSessionOption;

public interface CacheManager {
    public void initCacheManager();

    public <k, V> Map<k, V> getOrCreateCacheForSession(ReteEvaluator var1, String var2);

    public <k, V> Map<k, V> getOrCreateSharedCache(String var1);

    public void close();

    public void removeCache(String var1);

    public void removeCachesBySessionId(String var1);

    public void removeAllSessionCaches();

    public Set<String> getCacheNames();

    public static String createCacheId(ReteEvaluator reteEvaluator, String cacheName) {
        return "session_" + CacheManager.getSessionIdentifier(reteEvaluator) + "_" + cacheName;
    }

    private static long getSessionIdentifier(ReteEvaluator reteEvaluator) {
        PersistedSessionOption persistedSessionOption = reteEvaluator.getSessionConfiguration().getPersistedSessionOption();
        if (persistedSessionOption != null) {
            return persistedSessionOption.isNewSession() ? reteEvaluator.getIdentifier() : persistedSessionOption.getSessionId();
        }
        throw new ReliabilityConfigurationException("PersistedSessionOption has to be configured when drools-reliability is used");
    }
}

