/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.core.common.Storage;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.reliability.core.ReliabilityRuntimeException;
import org.drools.reliability.core.StoredObject;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;

public class ReliabilityUtils {
    private ReliabilityUtils() {
    }

    public static String getActivationKey(Match match) {
        return ReliabilityUtils.getActivationKey(match, null);
    }

    public static String getActivationKeyReplacingNewIdWithOldId(Match match, Map<Long, Long> factHandleIdMap) {
        return ReliabilityUtils.getActivationKey(match, factHandleIdMap);
    }

    private static String getActivationKey(Match match, Map<Long, Long> factHandleIdMap) {
        if (!(match instanceof RuleTerminalNodeLeftTuple)) {
            throw new ReliabilityRuntimeException("getActivationKey doesn't support " + match.getClass());
        }
        RuleTerminalNodeLeftTuple ruleTerminalNodeLeftTuple = (RuleTerminalNodeLeftTuple)match;
        String packageName = ruleTerminalNodeLeftTuple.getRule().getPackageName();
        String ruleName = ruleTerminalNodeLeftTuple.getRule().getName();
        List factHandles = ruleTerminalNodeLeftTuple.getFactHandles();
        List factHandleIdList = factHandles.stream().map(FactHandle::getId).map(handleId -> {
            if (factHandleIdMap != null) {
                return (Long)factHandleIdMap.get(handleId);
            }
            return handleId;
        }).collect(Collectors.toList());
        return "ActivationKey [packageName=" + packageName + ", ruleName=" + ruleName + ", factHandleIdList=" + factHandleIdList + "]";
    }

    public static void updateReferencedObjects(Storage<Long, StoredObject> storage, Map<String, Long> referencedObjects, Object object) {
        referencedObjects.keySet().forEach(fieldName -> {
            Optional<Field> refField = Arrays.stream(object.getClass().getDeclaredFields()).filter(f -> f.getName().equals(fieldName)).findFirst();
            if (refField.isPresent()) {
                refField.get().setAccessible(true);
                try {
                    refField.get().set(object, ((StoredObject)storage.get((Object)((Long)referencedObjects.get(refField.get().getName())))).getObject());
                }
                catch (IllegalAccessException e) {
                    throw new ReliabilityRuntimeException(e);
                }
            }
        });
    }
}

