/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.core;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.drools.core.common.Storage;
import org.drools.core.phreak.PhreakTimerNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.core.time.impl.TimerJobInstance;

public class ReliablePseudoClockScheduler
extends PseudoClockScheduler {
    private final transient Storage<String, Object> storage;
    private AtomicLong persistedTimer;

    public ReliablePseudoClockScheduler() {
        throw new UnsupportedOperationException("This constructor should not be used");
    }

    public ReliablePseudoClockScheduler(Storage<String, Object> storage) {
        this.storage = storage;
        this.timer = new AtomicLong(0L);
        this.persistedTimer = new AtomicLong((Long)storage.getOrDefault((Object)"timer", (Object)0L));
        this.idCounter = new AtomicLong((Long)storage.getOrDefault((Object)"idCounter", (Object)0L));
        List internalQueue = (List)storage.getOrDefault((Object)"internalQueue", new ArrayList());
        this.queue = new PriorityQueue(internalQueue);
    }

    public AtomicLong getPersistedTimer() {
        return this.persistedTimer;
    }

    public long advanceTime(long amount, TimeUnit unit) {
        long time = super.advanceTime(amount, unit);
        this.updateStorage();
        return time;
    }

    private void updateStorage() {
        this.storage.put((Object)"timer", (Object)this.timer.get());
        this.storage.put((Object)"idCounter", (Object)this.idCounter.get());
        this.storage.put((Object)"internalQueue", this.createFilteredInternalQueueForPersistence(this.queue));
    }

    public List<TimerJobInstance> createFilteredInternalQueueForPersistence(PriorityQueue<TimerJobInstance> queue) {
        return queue.stream().filter(job -> !(job.getJob() instanceof ObjectTypeNode.ExpireJob) && !(job.getJob() instanceof PhreakTimerNode.TimerNodeJob)).collect(Collectors.toList());
    }
}

