/*
 * Decompiled with CFR 0.152.
 */
package org.drools.quarkus.test.kmodule;

import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.drools.quarkus.test.kmodule.ProbeCounter;
import org.drools.quarkus.test.kmodule.ProbeEvent;
import org.drools.quarkus.test.kmodule.StockTick;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.KieRuntimeBuilder;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.time.SessionPseudoClock;

@Path(value="/test")
public class TestableResource {
    @Inject
    KieRuntimeBuilder runtimeBuilder;

    @GET
    @Path(value="testCepEvaluation")
    public Response testCepEvaluation() {
        KieSession ksession = this.runtimeBuilder.newKieSession("cepKS");
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        ksession.insert((Object)new StockTick("DROO"));
        clock.advanceTime(6L, TimeUnit.SECONDS);
        ksession.insert((Object)new StockTick("ACME"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        clock.advanceTime(4L, TimeUnit.SECONDS);
        ksession.insert((Object)new StockTick("ACME"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="testFireUntiHalt")
    public Response testFireUntiHalt() throws InterruptedException {
        KieSession ksession = this.runtimeBuilder.newKieSession("probeKS");
        new Thread(() -> ((KieSession)ksession).fireUntilHalt()).start();
        ProbeCounter pc = new ProbeCounter();
        ksession.insert((Object)pc);
        for (int i = 0; i < 10; ++i) {
            ksession.insert((Object)new ProbeEvent(i));
        }
        ProbeCounter probeCounter = pc;
        synchronized (probeCounter) {
            if (pc.getTotal() < 10) {
                try {
                    pc.wait();
                }
                catch (InterruptedException e) {
                    Assertions.fail((String)"couldn't lock in test ProbeCounter", (Throwable)e);
                    throw e;
                }
            }
        }
        Assertions.assertThat((int)pc.getTotal()).isEqualTo(10);
        return Response.ok().build();
    }

    @GET
    @Path(value="testAllPkgsKBase")
    public Response testAllPkgsKBase() {
        KieBase kBase = this.runtimeBuilder.getKieBase("allKB");
        List pkgNames = kBase.getKiePackages().stream().map(KiePackage::getName).collect(Collectors.toList());
        Assertions.assertThat(pkgNames).containsExactlyInAnyOrder((Object[])new String[]{"org.drools.quarkus.test.kmodule", "org.drools.cep", "org.drools.tms", "org.drools.probe"});
        return Response.ok().build();
    }

    @GET
    @Path(value="testTms")
    public Response testTms() {
        KieSession ksession = this.runtimeBuilder.newKieSession("tmsKS");
        FactHandle fh = ksession.insert((Object)"test");
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        Collection ints = ksession.getObjects(Integer.class::isInstance);
        Assertions.assertThat((Collection)ints).hasSize(1);
        Assertions.assertThat(ints.iterator().next()).isEqualTo((Object)4);
        ksession.delete(fh);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        ints = ksession.getObjects(Integer.class::isInstance);
        Assertions.assertThat((Collection)ints).isEmpty();
        return Response.ok().build();
    }
}

