/*
 * Decompiled with CFR 0.152.
 */
package org.drools.quarkus.ruleunit.examples.reactive;

import io.quarkus.runtime.Startup;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.drools.quarkus.ruleunit.examples.reactive.Alert;
import org.drools.quarkus.ruleunit.examples.reactive.AlertingUnit;
import org.drools.quarkus.ruleunit.examples.reactive.Event;
import org.drools.ruleunits.api.DataObserver;
import org.drools.ruleunits.api.RuleUnit;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Incoming;

@Startup
@ApplicationScoped
public class Adaptor {
    @Inject
    RuleUnit<AlertingUnit> ruleUnit;
    AlertingUnit alertingUnit;
    RuleUnitInstance<AlertingUnit> ruleUnitInstance;
    @Inject
    @Channel(value="alerts")
    Emitter<Alert> emitter;

    @PostConstruct
    void init() {
        this.alertingUnit = new AlertingUnit();
        this.ruleUnitInstance = this.ruleUnit.createInstance((RuleUnitData)this.alertingUnit);
        this.alertingUnit.getAlertData().subscribe(DataObserver.of(arg_0 -> this.emitter.send(arg_0)));
    }

    @Incoming(value="events")
    public void receive(Event event) throws InterruptedException {
        this.alertingUnit.getEventData().append((Object)event);
        this.ruleUnitInstance.fire();
    }
}

