/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.rule.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.drools.QueryResult;
import org.drools.QueryResults;
import org.drools.rule.Declaration;
import org.drools.runtime.rule.impl.NativeQueryResultRow;
import org.kie.runtime.rule.QueryResultsRow;

public class NativeQueryResults
implements org.kie.runtime.rule.QueryResults {
    private QueryResults results;
    private String[] identifiers;

    public NativeQueryResults() {
    }

    public NativeQueryResults(QueryResults results) {
        this.results = results;
    }

    public QueryResults getResults() {
        return this.results;
    }

    public String[] getIdentifiers() {
        if (this.identifiers != null) {
            return this.identifiers;
        }
        Declaration[] parameters = this.results.getParameters();
        HashSet<String> set = new HashSet<String>();
        for (Declaration declr : parameters) {
            set.add(declr.getIdentifier());
        }
        ArrayList<Declaration> declrCollection = new ArrayList<Declaration>(this.results.getDeclarations(0).values());
        Iterator it = declrCollection.iterator();
        while (it.hasNext()) {
            Declaration declr = (Declaration)it.next();
            if (!set.contains(declr.getIdentifier())) continue;
            it.remove();
        }
        String[] declrs = new String[parameters.length + declrCollection.size()];
        int i = 0;
        for (Declaration declr : parameters) {
            declrs[i++] = declr.getIdentifier();
        }
        for (Declaration declr : declrCollection) {
            declrs[i++] = declr.getIdentifier();
        }
        this.identifiers = declrs;
        return this.identifiers;
    }

    public Map<String, Declaration> getDeclarations() {
        return this.getResults().getDeclarations(0);
    }

    public int size() {
        return this.getResults().size();
    }

    public Iterator<QueryResultsRow> iterator() {
        return new QueryResultsIterator(this.getResults().iterator());
    }

    private class QueryResultsIterator
    implements Iterator<QueryResultsRow> {
        private Iterator<QueryResult> iterator;

        public QueryResultsIterator(Iterator<QueryResult> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public QueryResultsRow next() {
            return new NativeQueryResultRow(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

