/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.kie.runtime.rule.AccumulateFunction;

public class MinAccumulateFunction
implements AccumulateFunction {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public Serializable createContext() {
        return new MinData();
    }

    public void init(Serializable context) throws Exception {
        MinData data = (MinData)context;
        data.min = Double.MAX_VALUE;
    }

    public void accumulate(Serializable context, Object value) {
        MinData data = (MinData)context;
        data.min = Math.min(data.min, ((Number)value).doubleValue());
    }

    public void reverse(Serializable context, Object value) throws Exception {
    }

    public Object getResult(Serializable context) throws Exception {
        MinData data = (MinData)context;
        return new Double(data.min);
    }

    public boolean supportsReverse() {
        return false;
    }

    public Class<?> getResultType() {
        return Number.class;
    }

    protected static class MinData
    implements Externalizable {
        public double min = Double.MAX_VALUE;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.min = in.readDouble();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeDouble(this.min);
        }
    }
}

