/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Map;
import org.drools.KnowledgeBase;
import org.drools.RuleBase;
import org.drools.SessionConfiguration;
import org.drools.command.Command;
import org.drools.command.CommandService;
import org.drools.command.Context;
import org.drools.command.impl.ContextImpl;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.command.runtime.DisposeCommand;
import org.drools.common.EndOperationListener;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.persistence.processinstance.JPAWorkItemManager;
import org.drools.persistence.session.DefaultJpaManager;
import org.drools.persistence.session.JPASessionMarshallingHelper;
import org.drools.persistence.session.JpaJDKTimerService;
import org.drools.persistence.session.JpaManager;
import org.drools.persistence.session.JtaTransactionManager;
import org.drools.persistence.session.SessionInfo;
import org.drools.persistence.session.TransactionManager;
import org.drools.persistence.session.TransactionSynchronization;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleSessionCommandService
implements org.drools.command.SingleSessionCommandService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private SessionInfo sessionInfo;
    private JPASessionMarshallingHelper marshallingHelper;
    private StatefulKnowledgeSession ksession;
    private Environment env;
    private KnowledgeCommandContext kContext;
    private TransactionManager txm;
    private JpaManager jpm;
    private volatile boolean doRollback;
    private static Map<Object, Object> synchronizations = Collections.synchronizedMap(new IdentityHashMap());
    public static Map<Object, Object> txManagerClasses = Collections.synchronizedMap(new IdentityHashMap());

    public void checkEnvironment(Environment env) {
        if (env.get("drools.persistence.jpa.EntityManagerFactory") == null) {
            throw new IllegalArgumentException("Environment must have an EntityManagerFactory");
        }
    }

    public SingleSessionCommandService(RuleBase ruleBase, SessionConfiguration conf, Environment env) {
        this((KnowledgeBase)new KnowledgeBaseImpl(ruleBase), (KnowledgeSessionConfiguration)conf, env);
    }

    public SingleSessionCommandService(int sessionId, RuleBase ruleBase, SessionConfiguration conf, Environment env) {
        this(sessionId, (KnowledgeBase)new KnowledgeBaseImpl(ruleBase), (KnowledgeSessionConfiguration)conf, env);
    }

    public SingleSessionCommandService(KnowledgeBase kbase, KnowledgeSessionConfiguration conf, Environment env) {
        if (conf == null) {
            conf = new SessionConfiguration();
        }
        this.env = env;
        this.checkEnvironment(this.env);
        this.sessionInfo = new SessionInfo();
        this.initTransactionManager(this.env);
        this.ksession = kbase.newStatefulKnowledgeSession(conf, this.env);
        this.kContext = new KnowledgeCommandContext((Context)new ContextImpl("ksession", null), null, null, this.ksession, null);
        ((JpaJDKTimerService)((InternalKnowledgeRuntime)this.ksession).getTimerService()).setCommandService((CommandService)this);
        this.marshallingHelper = new JPASessionMarshallingHelper(this.ksession, conf);
        this.sessionInfo.setJPASessionMashallingHelper(this.marshallingHelper);
        ((InternalKnowledgeRuntime)this.ksession).setEndOperationListener((EndOperationListener)new EndOperationListenerImpl(this.sessionInfo));
        try {
            this.txm.begin();
            this.registerRollbackSync();
            this.jpm.getApplicationScopedEntityManager().persist((Object)this.sessionInfo);
            this.txm.commit();
        }
        catch (Exception t1) {
            try {
                this.txm.rollback();
            }
            catch (Throwable t2) {
                throw new RuntimeException("Could not commit session or rollback", t2);
            }
            throw new RuntimeException("Could not commit session", t1);
        }
        ((InternalKnowledgeRuntime)this.ksession).setId(this.sessionInfo.getId());
    }

    public SingleSessionCommandService(int sessionId, KnowledgeBase kbase, KnowledgeSessionConfiguration conf, Environment env) {
        if (conf == null) {
            conf = new SessionConfiguration();
        }
        this.env = env;
        this.checkEnvironment(this.env);
        this.initTransactionManager(this.env);
        this.initKsession(sessionId, kbase, conf);
    }

    public void initKsession(int sessionId, KnowledgeBase kbase, KnowledgeSessionConfiguration conf) {
        if (!this.doRollback && this.ksession != null) {
            return;
        }
        this.doRollback = false;
        try {
            this.sessionInfo = (SessionInfo)this.jpm.getApplicationScopedEntityManager().find(SessionInfo.class, (Object)sessionId);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find session data for id " + sessionId, e);
        }
        if (this.sessionInfo == null) {
            throw new RuntimeException("Could not find session data for id " + sessionId);
        }
        if (this.marshallingHelper == null) {
            this.marshallingHelper = new JPASessionMarshallingHelper(kbase, conf, this.env);
        }
        this.sessionInfo.setJPASessionMashallingHelper(this.marshallingHelper);
        this.ksession = this.marshallingHelper.loadSnapshot(this.sessionInfo.getData(), this.ksession);
        ((InternalKnowledgeRuntime)this.ksession).setId(this.sessionInfo.getId());
        ((InternalKnowledgeRuntime)this.ksession).setEndOperationListener((EndOperationListener)new EndOperationListenerImpl(this.sessionInfo));
        ((JpaJDKTimerService)((InternalKnowledgeRuntime)this.ksession).getTimerService()).setCommandService((CommandService)this);
        if (this.kContext == null) {
            this.kContext = new KnowledgeCommandContext((Context)new ContextImpl("ksession", null), null, null, this.ksession, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initTransactionManager(Environment env) {
        Object tm = env.get("drools.transaction.TransactionManager");
        if (tm != null && tm.getClass().getName().startsWith("org.springframework")) {
            try {
                Class<?> cls = Class.forName("org.drools.container.spring.beans.persistence.DroolsSpringTransactionManager");
                Constructor<?> con = cls.getConstructors()[0];
                this.txm = (TransactionManager)con.newInstance(tm);
                this.logger.debug("Instantiating  DroolsSpringTransactionManager");
                if (!tm.getClass().getName().toLowerCase().contains("jpa")) return;
                cls = Class.forName("org.drools.container.spring.beans.persistence.DroolsSpringJpaManager");
                con = cls.getConstructors()[0];
                this.jpm = (JpaManager)con.newInstance(this.env);
                return;
            }
            catch (Exception e) {
                this.logger.warn("Could not instatiate DroolsSpringTransactionManager");
                throw new RuntimeException("Could not instatiate org.drools.container.spring.beans.persistence.DroolsSpringTransactionManager", e);
            }
        } else {
            this.logger.debug("Instantiating  JtaTransactionManager");
            this.txm = new JtaTransactionManager(env.get("drools.transaction.Transaction"), env.get("drools.transaction.TransactionSynchronizationRegistry"), tm);
            this.jpm = new DefaultJpaManager(this.env);
        }
    }

    public Context getContext() {
        return this.kContext;
    }

    public synchronized <T> T execute(Command<T> command) {
        try {
            this.txm.begin();
            this.initKsession(this.sessionInfo.getId(), this.marshallingHelper.getKbase(), this.marshallingHelper.getConf());
            this.jpm.beginCommandScopedEntityManager();
            this.registerRollbackSync();
            Object result = ((GenericCommand)command).execute((Context)this.kContext);
            this.txm.commit();
            Object object = result;
            return (T)object;
        }
        catch (RuntimeException re) {
            this.rollbackTransaction(re);
            throw re;
        }
        catch (Exception t1) {
            this.rollbackTransaction(t1);
            throw new RuntimeException("Wrapped exception see cause", t1);
        }
        finally {
            if (command instanceof DisposeCommand) {
                this.jpm.dispose();
            }
        }
    }

    private void rollbackTransaction(Exception t1) {
        try {
            this.logger.error("Could not commit session", (Throwable)t1);
            this.txm.rollback();
        }
        catch (Exception t2) {
            this.logger.error("Could not rollback", (Throwable)t2);
            throw new RuntimeException("Could not commit session or rollback", t2);
        }
    }

    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    public int getSessionId() {
        return this.sessionInfo.getId();
    }

    private void registerRollbackSync() {
        if (synchronizations.get(this) == null) {
            this.txm.registerTransactionSynchronization(new SynchronizationImpl(this));
            synchronizations.put(this, this);
        }
    }

    private void rollback() {
        this.doRollback = true;
    }

    private static class SynchronizationImpl
    implements TransactionSynchronization {
        SingleSessionCommandService service;

        public SynchronizationImpl(SingleSessionCommandService service) {
            this.service = service;
        }

        public void afterCompletion(int status) {
            if (status != 0) {
                this.service.rollback();
            }
            synchronizations.remove(this.service);
            this.service.jpm.endCommandScopedEntityManager();
            StatefulKnowledgeSession ksession = this.service.ksession;
            if (ksession != null) {
                ((InternalKnowledgeRuntime)ksession).getProcessRuntime().clearProcessInstances();
                ((JPAWorkItemManager)ksession.getWorkItemManager()).clearWorkItems();
            }
        }

        public void beforeCompletion() {
        }
    }

    public static class EndOperationListenerImpl
    implements EndOperationListener {
        private SessionInfo info;

        public EndOperationListenerImpl(SessionInfo info) {
            this.info = info;
        }

        public void endOperation(InternalKnowledgeRuntime kruntime) {
            this.info.setLastModificationDate(new Date(kruntime.getLastIdleTimestamp()));
        }
    }
}

