/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.processinstance;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import org.drools.WorkItemHandlerNotFoundException;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.persistence.processinstance.WorkItemInfo;
import org.drools.process.instance.WorkItem;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.runtime.Environment;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAWorkItemManager
implements org.drools.process.instance.WorkItemManager {
    private InternalKnowledgeRuntime kruntime;
    private Map<String, WorkItemHandler> workItemHandlers = new HashMap<String, WorkItemHandler>();
    private transient Map<Long, WorkItemInfo> workItems;

    public JPAWorkItemManager(InternalKnowledgeRuntime kruntime) {
        this.kruntime = kruntime;
    }

    public void internalExecuteWorkItem(WorkItem workItem) {
        Environment env = this.kruntime.getEnvironment();
        EntityManager em = (EntityManager)env.get("drools.persistence.jpa.CmdScopedEntityManager");
        WorkItemInfo workItemInfo = new WorkItemInfo(workItem, env);
        em.persist((Object)workItemInfo);
        ((WorkItemImpl)workItem).setId(workItemInfo.getId());
        workItemInfo.update();
        if (this.workItems == null) {
            this.workItems = new HashMap<Long, WorkItemInfo>();
        }
        this.workItems.put(workItem.getId(), workItemInfo);
        WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler != null) {
            handler.executeWorkItem((org.drools.runtime.process.WorkItem)workItem, (WorkItemManager)this);
        } else {
            this.throwWorkItemNotFoundException(workItem);
        }
    }

    private void throwWorkItemNotFoundException(WorkItem workItem) {
        throw new WorkItemHandlerNotFoundException("Could not find work item handler for " + workItem.getName(), workItem.getName());
    }

    public void internalAbortWorkItem(long id) {
        Environment env = this.kruntime.getEnvironment();
        EntityManager em = (EntityManager)env.get("drools.persistence.jpa.CmdScopedEntityManager");
        WorkItemInfo workItemInfo = (WorkItemInfo)em.find(WorkItemInfo.class, (Object)id);
        if (workItemInfo != null) {
            WorkItemImpl workItem = (WorkItemImpl)workItemInfo.getWorkItem(env);
            WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler != null) {
                handler.abortWorkItem((org.drools.runtime.process.WorkItem)workItem, (WorkItemManager)this);
            } else if (this.workItems != null) {
                this.workItems.remove(id);
                this.throwWorkItemNotFoundException((WorkItem)workItem);
            }
            if (this.workItems != null) {
                this.workItems.remove(id);
            }
            em.remove((Object)workItemInfo);
        }
    }

    public void internalAddWorkItem(WorkItem workItem) {
    }

    public void completeWorkItem(long id, Map<String, Object> results) {
        Environment env = this.kruntime.getEnvironment();
        EntityManager em = (EntityManager)env.get("drools.persistence.jpa.CmdScopedEntityManager");
        WorkItemInfo workItemInfo = null;
        if (this.workItems != null && (workItemInfo = this.workItems.get(id)) != null) {
            workItemInfo = (WorkItemInfo)em.merge((Object)workItemInfo);
        }
        if (workItemInfo == null) {
            workItemInfo = (WorkItemInfo)em.find(WorkItemInfo.class, (Object)id);
        }
        if (workItemInfo != null) {
            WorkItemImpl workItem = (WorkItemImpl)workItemInfo.getWorkItem(env);
            workItem.setResults(results);
            ProcessInstance processInstance = this.kruntime.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(2);
            if (processInstance != null) {
                processInstance.signalEvent("workItemCompleted", (Object)workItem);
            }
            em.remove((Object)workItemInfo);
            if (this.workItems != null) {
                this.workItems.remove(workItem.getId());
            }
        }
    }

    public void abortWorkItem(long id) {
        Environment env = this.kruntime.getEnvironment();
        EntityManager em = (EntityManager)env.get("drools.persistence.jpa.CmdScopedEntityManager");
        WorkItemInfo workItemInfo = null;
        if (this.workItems != null) {
            workItemInfo = this.workItems.get(id);
            em.merge((Object)workItemInfo);
        }
        if (workItemInfo == null) {
            workItemInfo = (WorkItemInfo)em.find(WorkItemInfo.class, (Object)id);
        }
        if (workItemInfo != null) {
            WorkItemImpl workItem = (WorkItemImpl)workItemInfo.getWorkItem(env);
            ProcessInstance processInstance = this.kruntime.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(3);
            if (processInstance != null) {
                processInstance.signalEvent("workItemAborted", (Object)workItem);
            }
            em.remove((Object)workItemInfo);
            if (this.workItems != null) {
                this.workItems.remove(workItem.getId());
            }
        }
    }

    public WorkItem getWorkItem(long id) {
        Environment env = this.kruntime.getEnvironment();
        EntityManager em = (EntityManager)env.get("drools.persistence.jpa.CmdScopedEntityManager");
        WorkItemInfo workItemInfo = null;
        if (this.workItems != null) {
            workItemInfo = this.workItems.get(id);
        }
        if (workItemInfo == null && em != null) {
            workItemInfo = (WorkItemInfo)em.find(WorkItemInfo.class, (Object)id);
        }
        if (workItemInfo == null) {
            return null;
        }
        return workItemInfo.getWorkItem(env);
    }

    public Set<WorkItem> getWorkItems() {
        return new HashSet<WorkItem>();
    }

    public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        this.workItemHandlers.put(workItemName, handler);
    }

    public void clearWorkItems() {
        if (this.workItems != null) {
            this.workItems.clear();
        }
    }

    public void clear() {
        this.clearWorkItems();
    }
}

