/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jpa.grid;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.drools.KnowledgeBase;
import org.drools.SessionConfiguration;
import org.drools.builder.JPAKnowledgeFactoryService;
import org.drools.command.CommandService;
import org.drools.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.persistence.processinstance.JPAProcessInstanceManagerFactory;
import org.drools.persistence.processinstance.JPASignalManagerFactory;
import org.drools.persistence.processinstance.JPAWorkItemManagerFactory;
import org.drools.persistence.session.SingleSessionCommandService;
import org.drools.process.instance.ProcessInstanceManagerFactory;
import org.drools.process.instance.WorkItemManagerFactory;
import org.drools.process.instance.event.SignalManagerFactory;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAKnowledgeProviderLocalClient
implements JPAKnowledgeFactoryService {
    private Class<? extends CommandService> commandServiceClass;
    private Class<? extends ProcessInstanceManagerFactory> processInstanceManagerFactoryClass;
    private Class<? extends WorkItemManagerFactory> workItemManagerFactoryClass;
    private Class<? extends SignalManagerFactory> processSignalManagerFactoryClass;
    private Properties configProps = new Properties();

    public JPAKnowledgeProviderLocalClient() {
        this.setDefaultImplementations();
    }

    protected void setDefaultImplementations() {
        this.setCommandServiceClass(SingleSessionCommandService.class);
        this.setProcessInstanceManagerFactoryClass(JPAProcessInstanceManagerFactory.class);
        this.setWorkItemManagerFactoryClass(JPAWorkItemManagerFactory.class);
        this.setProcessSignalManagerFactoryClass(JPASignalManagerFactory.class);
    }

    public StatefulKnowledgeSession newStatefulKnowledgeSession(KnowledgeBase kbase, KnowledgeSessionConfiguration configuration, Environment environment) {
        if (configuration == null) {
            configuration = new SessionConfiguration();
        }
        if (environment == null) {
            throw new IllegalArgumentException("Environment cannot be null");
        }
        return new CommandBasedStatefulKnowledgeSession(this.buildCommanService(kbase, this.mergeConfig(configuration), environment));
    }

    public StatefulKnowledgeSession loadStatefulKnowledgeSession(int id, KnowledgeBase kbase, KnowledgeSessionConfiguration configuration, Environment environment) {
        if (configuration == null) {
            configuration = new SessionConfiguration();
        }
        if (environment == null) {
            throw new IllegalArgumentException("Environment cannot be null");
        }
        return new CommandBasedStatefulKnowledgeSession(this.buildCommanService(id, kbase, this.mergeConfig(configuration), environment));
    }

    private CommandService buildCommanService(int sessionId, KnowledgeBase kbase, KnowledgeSessionConfiguration conf, Environment env) {
        try {
            Class<? extends CommandService> serviceClass = this.getCommandServiceClass();
            Constructor<? extends CommandService> constructor = serviceClass.getConstructor(Integer.TYPE, KnowledgeBase.class, KnowledgeSessionConfiguration.class, Environment.class);
            return constructor.newInstance(sessionId, kbase, conf, env);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private CommandService buildCommanService(KnowledgeBase kbase, KnowledgeSessionConfiguration conf, Environment env) {
        Class<? extends CommandService> serviceClass = this.getCommandServiceClass();
        try {
            Constructor<? extends CommandService> constructor = serviceClass.getConstructor(KnowledgeBase.class, KnowledgeSessionConfiguration.class, Environment.class);
            return constructor.newInstance(kbase, conf, env);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private KnowledgeSessionConfiguration mergeConfig(KnowledgeSessionConfiguration configuration) {
        ((SessionConfiguration)configuration).addProperties(this.configProps);
        return configuration;
    }

    public int getStatefulKnowledgeSessionId(StatefulKnowledgeSession ksession) {
        if (ksession instanceof CommandBasedStatefulKnowledgeSession) {
            SingleSessionCommandService commandService = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService();
            return commandService.getSessionId();
        }
        throw new IllegalArgumentException("StatefulKnowledgeSession must be an a CommandBasedStatefulKnowledgeSession");
    }

    public void setCommandServiceClass(Class<? extends CommandService> commandServiceClass) {
        if (commandServiceClass != null) {
            this.commandServiceClass = commandServiceClass;
            this.configProps.put("drools.commandService", commandServiceClass.getName());
        }
    }

    public Class<? extends CommandService> getCommandServiceClass() {
        return this.commandServiceClass;
    }

    public void setProcessInstanceManagerFactoryClass(Class<? extends ProcessInstanceManagerFactory> processInstanceManagerFactoryClass) {
        if (processInstanceManagerFactoryClass != null) {
            this.processInstanceManagerFactoryClass = processInstanceManagerFactoryClass;
            this.configProps.put("drools.processInstanceManagerFactory", processInstanceManagerFactoryClass.getName());
        }
    }

    public Class<? extends ProcessInstanceManagerFactory> getProcessInstanceManagerFactoryClass() {
        return this.processInstanceManagerFactoryClass;
    }

    public void setWorkItemManagerFactoryClass(Class<? extends WorkItemManagerFactory> workItemManagerFactoryClass) {
        if (workItemManagerFactoryClass != null) {
            this.workItemManagerFactoryClass = workItemManagerFactoryClass;
            this.configProps.put("drools.workItemManagerFactory", workItemManagerFactoryClass.getName());
        }
    }

    public Class<? extends WorkItemManagerFactory> getWorkItemManagerFactoryClass() {
        return this.workItemManagerFactoryClass;
    }

    public void setProcessSignalManagerFactoryClass(Class<? extends SignalManagerFactory> processSignalManagerFactoryClass) {
        if (processSignalManagerFactoryClass != null) {
            this.processSignalManagerFactoryClass = processSignalManagerFactoryClass;
            this.configProps.put("drools.processSignalManagerFactory", processSignalManagerFactoryClass.getName());
        }
    }

    public Class<? extends SignalManagerFactory> getProcessSignalManagerFactoryClass() {
        return this.processSignalManagerFactoryClass;
    }
}

