/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.drools.persistence.session.JtaTransactionSynchronizationAdapter;
import org.drools.persistence.session.TransactionManager;
import org.drools.persistence.session.TransactionSynchronization;
import org.drools.persistence.session.TransactionSynchronizationRegistryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtaTransactionManager
implements TransactionManager {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    public static final String[] FALLBACK_TRANSACTION_MANAGER_NAMES = new String[]{"java:comp/TransactionManager", "java:appserver/TransactionManager", "java:pm/TransactionManager", "java:/TransactionManager"};
    public static final String DEFAULT_TRANSACTION_SYNCHRONIZATION_REGISTRY_NAME = "java:comp/TransactionSynchronizationRegistry";
    private static final String TRANSACTION_SYNCHRONIZATION_REGISTRY_CLASS_NAME = "javax.transaction.TransactionSynchronizationRegistry";
    private static Class<?> transactionSynchronizationRegistryClass;
    UserTransaction ut;
    Object tsr;
    javax.transaction.TransactionManager tm;
    private boolean localTransaction;

    public JtaTransactionManager(Object ut, Object tsr, Object tm) {
        this.ut = ut instanceof UserTransaction ? (UserTransaction)ut : (UserTransaction)(ut != null ? ut : this.findUserTransaction());
        this.tm = tm instanceof javax.transaction.TransactionManager ? (javax.transaction.TransactionManager)tm : (javax.transaction.TransactionManager)(tm != null ? tm : this.findTransactionManager(this.ut));
        this.tsr = tsr != null ? tsr : this.findTransactionSynchronizationRegistry(this.ut, this.tm);
    }

    protected javax.transaction.TransactionManager findTransactionManager(UserTransaction ut) {
        if (ut instanceof TransactionManager) {
            this.logger.debug("JTA UserTransaction object [{}] implements TransactionManager", (Object)ut);
            return (javax.transaction.TransactionManager)ut;
        }
        InitialContext context = null;
        try {
            context = new InitialContext();
        }
        catch (NamingException ex) {
            this.logger.debug("Could not initialise JNDI InitialContext", (Throwable)ex);
            return null;
        }
        for (String jndiName : FALLBACK_TRANSACTION_MANAGER_NAMES) {
            try {
                javax.transaction.TransactionManager tm = (javax.transaction.TransactionManager)context.lookup(jndiName);
                this.logger.debug("JTA TransactionManager found at fallback JNDI location [{}]", (Object)jndiName);
                return tm;
            }
            catch (NamingException ex) {
                this.logger.debug("No JTA TransactionManager found at fallback JNDI location [{}]", (Object)jndiName, (Object)ex);
            }
        }
        return null;
    }

    protected UserTransaction findUserTransaction() {
        try {
            InitialContext context = new InitialContext();
            return (UserTransaction)context.lookup(DEFAULT_USER_TRANSACTION_NAME);
        }
        catch (NamingException ex) {
            this.logger.debug("No UserTransaction found at JNDI location [{}]", (Object)DEFAULT_USER_TRANSACTION_NAME, (Object)ex);
            return null;
        }
    }

    protected Object findTransactionSynchronizationRegistry(UserTransaction ut, javax.transaction.TransactionManager tm) {
        if (transactionSynchronizationRegistryClass == null) {
            this.logger.debug("JTA 1.1 [{}] API not available", (Object)TRANSACTION_SYNCHRONIZATION_REGISTRY_CLASS_NAME);
            return null;
        }
        String jndiName = DEFAULT_TRANSACTION_SYNCHRONIZATION_REGISTRY_NAME;
        try {
            InitialContext context = new InitialContext();
            context.lookup(jndiName);
            this.logger.debug("JTA TransactionSynchronizationRegistry found at default JNDI location [{}]", (Object)jndiName);
            return this.tsr;
        }
        catch (NamingException ex) {
            this.logger.debug("No JTA TransactionSynchronizationRegistry found at default JNDI location [{}]", (Object)jndiName, (Object)ex);
            if (transactionSynchronizationRegistryClass.isInstance(ut)) {
                return ut;
            }
            if (transactionSynchronizationRegistryClass.isInstance(tm)) {
                return tm;
            }
            return null;
        }
    }

    public void begin() {
        if (this.getStatus() == 3) {
            this.localTransaction = true;
            try {
                this.ut.begin();
            }
            catch (Exception e) {
                this.logger.warn("Unable to begin transaction", (Throwable)e);
                throw new RuntimeException("Unable to begin transaction", e);
            }
        } else {
            this.localTransaction = false;
        }
    }

    public void commit() {
        if (this.localTransaction) {
            try {
                this.ut.commit();
            }
            catch (Exception e) {
                this.logger.warn("Unable to commit transaction", (Throwable)e);
                throw new RuntimeException("Unable to commit transaction", e);
            }
        } else {
            this.localTransaction = false;
        }
    }

    public void rollback() {
        this.localTransaction = false;
        try {
            this.ut.rollback();
        }
        catch (Exception e) {
            this.logger.warn("Unable to rollback transaction", (Throwable)e);
            throw new RuntimeException("Unable to rollback transaction", e);
        }
    }

    public int getStatus() {
        int s;
        try {
            s = this.ut.getStatus();
        }
        catch (SystemException e) {
            throw new RuntimeException("Unable to get status for transaction", e);
        }
        switch (s) {
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 6: {
                return 3;
            }
        }
        return 2;
    }

    public void registerTransactionSynchronization(TransactionSynchronization ts) {
        if (this.tsr != null) {
            TransactionSynchronizationRegistryHelper.registerTransactionSynchronization(this.tsr, ts);
        } else if (this.tm != null) {
            try {
                this.tm.getTransaction().registerSynchronization((Synchronization)new JtaTransactionSynchronizationAdapter(ts));
            }
            catch (Exception e) {
                this.logger.warn("Participating in existing JTA transaction, but no JTA TransactionManager or TransactionSychronizationRegistry available: ", (Throwable)e);
            }
        } else {
            this.logger.warn("Participating in existing JTA transaction, but no JTA TransactionManager or TransactionSychronizationRegistry available: ");
        }
    }

    static {
        ClassLoader cl = JtaTransactionManager.class.getClassLoader();
        try {
            transactionSynchronizationRegistryClass = cl.loadClass(TRANSACTION_SYNCHRONIZATION_REGISTRY_CLASS_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

