/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.util.Map;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.collections.map.IdentityMap;
import org.drools.KnowledgeBase;
import org.drools.RuleBase;
import org.drools.SessionConfiguration;
import org.drools.StatefulSession;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.persistence.processinstance.JPASignalManager;
import org.drools.persistence.session.JPASessionMarshallingHelper;
import org.drools.persistence.session.SessionInfo;
import org.drools.process.command.Command;
import org.drools.process.command.CommandService;
import org.drools.reteoo.ReteooStatefulSession;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleSessionCommandService
implements CommandService {
    private EntityManagerFactory emf;
    private EntityManager em;
    private SessionInfo sessionInfo;
    private JPASessionMarshallingHelper marshallingHelper;
    private StatefulSession session;
    private StatefulKnowledgeSession ksession;
    private Environment env;

    public void checkEnvironment(Environment env) {
        if (env.get("drools.persistence.jpa.EntityManagerFactory") == null) {
            throw new IllegalArgumentException("Environment must have an EntityManagerFactory");
        }
    }

    public SingleSessionCommandService(RuleBase ruleBase, SessionConfiguration conf, Environment env) {
        this((KnowledgeBase)new KnowledgeBaseImpl(ruleBase), (KnowledgeSessionConfiguration)conf, env);
    }

    public SingleSessionCommandService(KnowledgeBase kbase, KnowledgeSessionConfiguration conf, Environment env) {
        if (conf == null) {
            conf = new SessionConfiguration();
        }
        this.env = env;
        this.sessionInfo = new SessionInfo();
        this.session = ((KnowledgeBaseImpl)kbase).ruleBase.newStatefulSession((SessionConfiguration)conf, this.env);
        this.ksession = new StatefulKnowledgeSessionImpl((ReteooWorkingMemory)this.session);
        ((JPASignalManager)this.session.getSignalManager()).setCommandService(this);
        this.marshallingHelper = new JPASessionMarshallingHelper(this.ksession, conf);
        this.sessionInfo.setJPASessionMashallingHelper(this.marshallingHelper);
        this.emf = (EntityManagerFactory)env.get("drools.persistence.jpa.EntityManagerFactory");
        this.em = this.emf.createEntityManager();
        UserTransaction ut = null;
        try {
            InitialContext ctx = new InitialContext();
            ut = (UserTransaction)ctx.lookup("java:comp/UserTransaction");
            ut.begin();
            this.registerRollbackSync();
            this.em.joinTransaction();
            this.em.persist((Object)this.sessionInfo);
            ut.commit();
        }
        catch (Throwable t1) {
            try {
                if (ut != null) {
                    ut.rollback();
                }
                throw new RuntimeException("Could not insert session data", t1);
            }
            catch (Throwable t2) {
                throw new RuntimeException("Could not rollback transaction", t2);
            }
        }
        ((ReteooStatefulSession)this.session).setId(this.sessionInfo.getId());
        new Thread(new Runnable(){

            public void run() {
                SingleSessionCommandService.this.session.fireUntilHalt();
            }
        });
    }

    public SingleSessionCommandService(int sessionId, KnowledgeBase kbase, KnowledgeSessionConfiguration conf, Environment env) {
        if (conf == null) {
            conf = new SessionConfiguration();
        }
        this.env = env;
        this.emf = (EntityManagerFactory)env.get("drools.persistence.jpa.EntityManagerFactory");
        this.em = this.emf.createEntityManager();
        UserTransaction ut = null;
        try {
            InitialContext ctx = new InitialContext();
            ut = (UserTransaction)ctx.lookup("java:comp/UserTransaction");
            ut.begin();
            this.registerRollbackSync();
            this.em.joinTransaction();
            this.sessionInfo = (SessionInfo)this.em.find(SessionInfo.class, (Object)sessionId);
            ut.commit();
        }
        catch (Throwable t1) {
            try {
                if (ut != null) {
                    ut.rollback();
                }
                throw new RuntimeException("Could insert session data", t1);
            }
            catch (Throwable t2) {
                throw new RuntimeException("Could not rollback transaction", t2);
            }
        }
        this.session = ((KnowledgeBaseImpl)kbase).ruleBase.newStatefulSession((SessionConfiguration)conf, this.env);
        ((ReteooStatefulSession)this.session).setId(sessionId);
        this.ksession = new StatefulKnowledgeSessionImpl((ReteooWorkingMemory)this.session);
        ((JPASignalManager)this.session.getSignalManager()).setCommandService(this);
        this.marshallingHelper = new JPASessionMarshallingHelper(this.sessionInfo, kbase, conf, env);
        this.sessionInfo.setJPASessionMashallingHelper(this.marshallingHelper);
        this.ksession = this.marshallingHelper.getObject();
        this.session = (StatefulSession)((StatefulKnowledgeSessionImpl)this.ksession).session;
        ((JPASignalManager)this.session.getSignalManager()).setCommandService(this);
        new Thread(new Runnable(){

            public void run() {
                SingleSessionCommandService.this.session.fireUntilHalt();
            }
        });
    }

    public StatefulSession getSession() {
        return this.session;
    }

    public synchronized <T> T execute(Command<T> command) {
        Object object;
        this.session.halt();
        boolean localTransaction = false;
        UserTransaction ut = null;
        try {
            ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
            if (ut.getStatus() == 6) {
                ut.begin();
                localTransaction = true;
            }
            EntityManager localEm = this.emf.createEntityManager();
            this.env.set("drools.persistence.jpa.EntityManager", (Object)localEm);
            if (this.em == null) {
                this.em = this.emf.createEntityManager();
                this.sessionInfo = (SessionInfo)this.em.find(SessionInfo.class, (Object)this.sessionInfo.getId());
                this.sessionInfo.setJPASessionMashallingHelper(this.marshallingHelper);
                this.marshallingHelper.loadSnapshot(this.sessionInfo.getData(), this.ksession);
                this.session = (StatefulSession)((StatefulKnowledgeSessionImpl)this.ksession).session;
            }
            this.em.joinTransaction();
            this.sessionInfo.setDirty();
            this.registerRollbackSync();
            Object result = command.execute((ReteooWorkingMemory)this.session);
            if (localTransaction) {
                ut.commit();
            }
            object = result;
            new Thread(new Runnable(){

                public void run() {
                    SingleSessionCommandService.this.session.fireUntilHalt();
                }
            });
        }
        catch (Throwable t1) {
            try {
                t1.printStackTrace();
                if (localTransaction) {
                    try {
                        if (ut != null) {
                            ut.rollback();
                        }
                        throw new RuntimeException("Could not execute command", t1);
                    }
                    catch (Throwable t2) {
                        throw new RuntimeException("Could not rollback transaction", t2);
                    }
                }
                throw new RuntimeException("Could not execute command", t1);
            }
            catch (Throwable throwable) {
                new Thread(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
        return (T)object;
    }

    public void dispose() {
        if (this.session != null) {
            this.session.dispose();
        }
    }

    public int getSessionId() {
        return this.sessionInfo.getId();
    }

    public void registerRollbackSync() throws IllegalStateException, RollbackException, SystemException {
        TransactionManager txm = (TransactionManager)this.env.get("drools.persistence.jpa.TransactionManager");
        if (txm == null) {
            return;
        }
        Map map = (Map)this.env.get("synchronizations");
        if (map == null) {
            map = new IdentityMap();
            this.env.set("synchronizations", (Object)map);
        }
        if (map.get(this) == null) {
            txm.getTransaction().registerSynchronization((Synchronization)new SynchronizationImpl(this.env, this));
            map.put(this, this);
        }
    }

    public void rollback() {
        this.em.close();
        this.em = null;
    }

    public static class SynchronizationImpl
    implements Synchronization {
        private Environment env;
        private SingleSessionCommandService cmdService;

        public SynchronizationImpl(Environment env, SingleSessionCommandService cmdService) {
            this.env = env;
            this.cmdService = cmdService;
        }

        public void afterCompletion(int status) {
            if (status != 3) {
                this.cmdService.rollback();
                System.out.println("after with local rollback: " + status);
            }
            System.out.println("cleanedup rollback sychronisation");
            Map map = (Map)this.env.get("synchronizations");
            map.remove(this.cmdService);
            EntityManager localEm = (EntityManager)this.env.get("drools.persistence.jpa.EntityManager");
            if (localEm != null && localEm.isOpen()) {
                localEm.close();
            }
        }

        public void beforeCompletion() {
        }
    }
}

