/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;
import org.drools.base.rule.accessor.Evaluator;
import org.drools.base.rule.accessor.FieldValue;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.time.Interval;
import org.drools.base.util.TimeIntervalParser;
import org.drools.compiler.rule.builder.EvaluatorDefinition;
import org.drools.core.common.DefaultEventHandle;
import org.drools.drl.parser.impl.Operator;
import org.drools.mvel.evaluators.BaseEvaluator;
import org.drools.mvel.evaluators.VariableRestriction;
import org.kie.api.runtime.rule.FactHandle;

public class OverlappedByEvaluatorDefinition
implements EvaluatorDefinition {
    public static final String overlappedbyOp = Operator.BuiltInOperator.OVERLAPPED_BY.getSymbol();
    public static final Operator OVERLAPPED_BY = Operator.determineOperator((String)overlappedbyOp, (boolean)false);
    public static final Operator NOT_OVERLAPPED_BY = Operator.determineOperator((String)overlappedbyOp, (boolean)true);
    private static final String[] SUPPORTED_IDS = new String[]{overlappedbyOp};
    private Map<String, OverlappedByEvaluator> cache = Collections.emptyMap();

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        OverlappedByEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, OverlappedByEvaluator>();
        }
        if ((eval = this.cache.get(key = isNegated + ":" + parameterText)) == null) {
            long[] params = TimeIntervalParser.parse((String)parameterText);
            eval = new OverlappedByEvaluator(type, isNegated, params, parameterText);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.HANDLE;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class OverlappedByEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        private long minDev;
        private long maxDev;
        private String paramText;

        public OverlappedByEvaluator() {
        }

        public OverlappedByEvaluator(ValueType type, boolean isNegated, long[] parameters, String paramText) {
            super(type, isNegated ? NOT_OVERLAPPED_BY : OVERLAPPED_BY);
            this.paramText = paramText;
            this.setParameters(parameters);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.minDev = in.readLong();
            this.maxDev = in.readLong();
            this.paramText = (String)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.minDev);
            out.writeLong(this.maxDev);
            out.writeObject(this.paramText);
        }

        @Override
        public boolean isTemporal() {
            return true;
        }

        @Override
        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(0L, Long.MAX_VALUE);
        }

        public boolean evaluate(ValueResolver valueResolver, ReadAccessor extractor, FactHandle object1, FieldValue object2) {
            throw new RuntimeException("The 'overlappedby' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        @Override
        public boolean evaluateCachedRight(ValueResolver valueResolver, VariableRestriction.VariableContextEntry context, FactHandle left) {
            if (context.rightNull || context.declaration.getExtractor().isNullValue(valueResolver, left.getObject())) {
                return false;
            }
            long rightStartTS = ((VariableRestriction.TemporalVariableContextEntry)context).startTS;
            long leftEndTS = ((DefaultEventHandle)left).getEndTimestamp();
            long dist = leftEndTS - rightStartTS;
            return this.getOperator().isNegated() ^ (((DefaultEventHandle)left).getStartTimestamp() < rightStartTS && leftEndTS < ((VariableRestriction.TemporalVariableContextEntry)context).endTS && dist >= this.minDev && dist <= this.maxDev);
        }

        @Override
        public boolean evaluateCachedLeft(ValueResolver valueResolver, VariableRestriction.VariableContextEntry context, FactHandle right) {
            if (context.leftNull || context.extractor.isNullValue(valueResolver, right.getObject())) {
                return false;
            }
            long leftEndTS = ((VariableRestriction.TemporalVariableContextEntry)context).endTS;
            long rightStartTS = ((DefaultEventHandle)right).getStartTimestamp();
            long dist = leftEndTS - rightStartTS;
            return this.getOperator().isNegated() ^ (((VariableRestriction.TemporalVariableContextEntry)context).startTS < rightStartTS && leftEndTS < ((DefaultEventHandle)right).getEndTimestamp() && dist >= this.minDev && dist <= this.maxDev);
        }

        public boolean evaluate(ValueResolver valueResolver, ReadAccessor extractor1, FactHandle handle1, ReadAccessor extractor2, FactHandle handle2) {
            if (extractor1.isNullValue(valueResolver, handle1.getObject()) || extractor2.isNullValue(valueResolver, handle2.getObject())) {
                return false;
            }
            long startTS = ((DefaultEventHandle)handle1).getStartTimestamp();
            long endTS = ((DefaultEventHandle)handle2).getEndTimestamp();
            long dist = endTS - startTS;
            return this.getOperator().isNegated() ^ (((DefaultEventHandle)handle2).getStartTimestamp() < startTS && endTS < ((DefaultEventHandle)handle1).getEndTimestamp() && dist >= this.minDev && dist <= this.maxDev);
        }

        @Override
        public String toString() {
            return "overlappedby[" + (this.paramText != null ? this.paramText : "") + "]";
        }

        @Override
        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.maxDev ^ this.maxDev >>> 32);
            result = 31 * result + (int)(this.minDev ^ this.minDev >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OverlappedByEvaluator other = (OverlappedByEvaluator)obj;
            return this.maxDev == other.maxDev && this.minDev == other.minDev;
        }

        private void setParameters(long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.minDev = 1L;
                this.maxDev = Long.MAX_VALUE;
            } else if (parameters.length == 1) {
                this.minDev = 1L;
                this.maxDev = parameters[0];
            } else if (parameters.length == 2) {
                this.minDev = parameters[0];
                this.maxDev = parameters[1];
            } else {
                throw new RuntimeException("[Overlaps Evaluator]: Not possible to use " + parameters.length + " parameters: '" + this.paramText + "'");
            }
        }
    }
}

