/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.asm;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.drools.compiler.builder.impl.classbuilder.BuildUtils;
import org.drools.compiler.builder.impl.classbuilder.EnumClassBuilder;
import org.drools.compiler.builder.impl.classbuilder.EnumClassDefinition;
import org.drools.compiler.builder.impl.classbuilder.EnumLiteralDefinition;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.mvel.asm.AsmUtil;
import org.drools.mvel.asm.ClassGenerator;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.FieldVisitor;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Opcodes;
import org.mvel2.asm.Type;

public class DefaultEnumClassBuilder
implements Opcodes,
EnumClassBuilder,
Serializable {
    public byte[] buildClass(ClassDefinition classDef, ClassLoader classLoader) throws IOException, SecurityException, IllegalArgumentException, ClassNotFoundException {
        if (!(classDef instanceof EnumClassDefinition)) {
            throw new RuntimeException("FATAL : Trying to create an enum out of a bean class definition  " + classDef);
        }
        EnumClassDefinition edef = (EnumClassDefinition)classDef;
        ClassWriter cw = this.buildClassHeader(classLoader, edef);
        this.buildLiterals(cw, edef);
        this.buildFields(cw, edef);
        this.buildConstructors(cw, edef);
        this.buildGettersAndSetters(cw, edef);
        this.buildEqualityMethods(cw, (ClassDefinition)edef);
        this.buildToString(cw, edef);
        cw.visitEnd();
        byte[] serializedClass = cw.toByteArray();
        return serializedClass;
    }

    protected ClassWriter buildClassHeader(ClassLoader classLoader, EnumClassDefinition classDef) {
        return ClassGenerator.createClassWriter(classLoader, 16433, BuildUtils.getInternalType((String)classDef.getClassName()), "Ljava/lang/Enum<" + BuildUtils.getTypeDescriptor((String)classDef.getClassName()) + ">;", BuildUtils.getInternalType((String)classDef.getSuperClass()), BuildUtils.getInternalTypes((String[])classDef.getInterfaces()));
    }

    protected void buildLiterals(ClassWriter cw, EnumClassDefinition classDef) {
        FieldVisitor fv;
        for (EnumLiteralDefinition lit : classDef.getEnumLiterals()) {
            fv = cw.visitField(16409, lit.getName(), BuildUtils.getTypeDescriptor((String)classDef.getClassName()), null, null);
            fv.visitEnd();
        }
        fv = cw.visitField(4122, "$VALUES", "[" + BuildUtils.getTypeDescriptor((String)classDef.getClassName()), null, null);
        fv.visitEnd();
    }

    protected void buildFields(ClassWriter cw, EnumClassDefinition classDef) {
        for (FieldDefinition fld : classDef.getFieldsDefinitions()) {
            FieldVisitor fv = cw.visitField(18, fld.getName(), BuildUtils.getTypeDescriptor((String)fld.getTypeName()), null, null);
            fv.visitEnd();
        }
    }

    protected void buildConstructors(ClassWriter cw, EnumClassDefinition classDef) {
        EnumLiteralDefinition lit;
        int j;
        StringBuilder argTypesBuilder = new StringBuilder();
        int size = 0;
        for (Object fld : classDef.getFieldsDefinitions()) {
            argTypesBuilder.append(BuildUtils.getTypeDescriptor((String)fld.getTypeName()));
            size += BuildUtils.sizeOf((String)fld.getTypeName());
        }
        int ofs = 3;
        MethodVisitor mv = cw.visitMethod(2, "<init>", "(Ljava/lang/String;I" + argTypesBuilder.toString() + ")V", "(" + argTypesBuilder.toString() + ")V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(183, "java/lang/Enum", "<init>", "(Ljava/lang/String;I)V");
        for (FieldDefinition fld : classDef.getFieldsDefinitions()) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(AsmUtil.varType(fld.getTypeName()), ofs);
            mv.visitFieldInsn(181, BuildUtils.getInternalType((String)classDef.getName()), fld.getName(), BuildUtils.getTypeDescriptor((String)fld.getTypeName()));
            ofs += BuildUtils.sizeOf((String)fld.getTypeName());
        }
        mv.visitInsn(177);
        mv.visitMaxs(3, ofs);
        mv.visitEnd();
        mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        int N = classDef.getEnumLiterals().size();
        mv.visitTypeInsn(187, BuildUtils.getInternalType((String)classDef.getClassName()));
        for (j = 0; j < N; ++j) {
            lit = (EnumLiteralDefinition)classDef.getEnumLiterals().get(j);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)lit.getName());
            AsmUtil.pushInt(mv, j);
            List args = lit.getConstructorArgs();
            for (int k = 0; k < args.size(); ++k) {
                String argType = classDef.getField(k).getTypeName();
                mv.visitLdcInsn(args.get(k));
                mv.visitMethodInsn(184, "org/mvel2/MVEL", "eval", "(Ljava/lang/String;)Ljava/lang/Object;");
                if (BuildUtils.isPrimitive((String)argType)) {
                    mv.visitTypeInsn(192, BuildUtils.getInternalType((String)BuildUtils.box((String)argType)));
                    mv.visitMethodInsn(182, BuildUtils.getInternalType((String)BuildUtils.box((String)argType)), BuildUtils.numericMorph((String)BuildUtils.box((String)argType)), "()" + BuildUtils.getTypeDescriptor((String)argType));
                    continue;
                }
                mv.visitTypeInsn(192, BuildUtils.getInternalType((String)argType));
            }
            mv.visitMethodInsn(183, BuildUtils.getInternalType((String)classDef.getClassName()), "<init>", "(Ljava/lang/String;I" + argTypesBuilder.toString() + ")V");
            mv.visitFieldInsn(179, BuildUtils.getInternalType((String)classDef.getClassName()), lit.getName(), BuildUtils.getTypeDescriptor((String)classDef.getClassName()));
            mv.visitTypeInsn(187, BuildUtils.getInternalType((String)classDef.getClassName()));
        }
        AsmUtil.pushInt(mv, N);
        mv.visitTypeInsn(189, BuildUtils.getInternalType((String)classDef.getClassName()));
        for (j = 0; j < N; ++j) {
            lit = (EnumLiteralDefinition)classDef.getEnumLiterals().get(j);
            mv.visitInsn(89);
            AsmUtil.pushInt(mv, j);
            mv.visitFieldInsn(178, BuildUtils.getInternalType((String)classDef.getClassName()), lit.getName(), BuildUtils.getTypeDescriptor((String)classDef.getClassName()));
            mv.visitInsn(83);
        }
        mv.visitFieldInsn(179, BuildUtils.getInternalType((String)classDef.getClassName()), "$VALUES", "[" + BuildUtils.getTypeDescriptor((String)classDef.getClassName()));
        mv.visitInsn(177);
        mv.visitMaxs(4 + size, 0);
        mv.visitEnd();
        mv = cw.visitMethod(9, "valueOf", "(Ljava/lang/String;)" + BuildUtils.getTypeDescriptor((String)classDef.getClassName()), null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)Type.getType((String)BuildUtils.getTypeDescriptor((String)classDef.getClassName())));
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/Enum", "valueOf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;");
        mv.visitTypeInsn(192, BuildUtils.getInternalType((String)classDef.getClassName()));
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    protected void buildGettersAndSetters(ClassWriter cw, EnumClassDefinition classDef) {
        MethodVisitor mv = cw.visitMethod(9, "values", "()[" + BuildUtils.getTypeDescriptor((String)classDef.getClassName()), null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, BuildUtils.getInternalType((String)classDef.getClassName()), "$VALUES", "[" + BuildUtils.getTypeDescriptor((String)classDef.getClassName()));
        mv.visitMethodInsn(182, "[" + BuildUtils.getTypeDescriptor((String)classDef.getClassName()), "clone", "()Ljava/lang/Object;");
        mv.visitTypeInsn(192, "[" + BuildUtils.getTypeDescriptor((String)classDef.getClassName()));
        mv.visitInsn(176);
        mv.visitMaxs(1, 0);
        mv.visitEnd();
        for (FieldDefinition fld : classDef.getFieldsDefinitions()) {
            mv = cw.visitMethod(1, BuildUtils.getterName((String)fld.getName(), (String)fld.getTypeName()), "()" + BuildUtils.getTypeDescriptor((String)fld.getTypeName()), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, BuildUtils.getInternalType((String)classDef.getName()), fld.getName(), BuildUtils.getTypeDescriptor((String)fld.getTypeName()));
            mv.visitInsn(AsmUtil.returnType(fld.getTypeName()));
            mv.visitMaxs(BuildUtils.sizeOf((String)fld.getTypeName()), 1);
            mv.visitEnd();
            mv = cw.visitMethod(1, BuildUtils.setterName((String)fld.getName()), "(" + BuildUtils.getTypeDescriptor((String)fld.getTypeName()) + ")V", null, null);
            mv.visitCode();
            mv.visitInsn(177);
            mv.visitMaxs(0, 1 + BuildUtils.sizeOf((String)fld.getTypeName()));
            mv.visitEnd();
        }
    }

    protected void buildToString(ClassWriter cw, EnumClassDefinition classDef) {
    }

    protected void buildEqualityMethods(ClassWriter cw, ClassDefinition classDef) {
    }
}

