/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.java;

import java.util.List;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.mvel.java.JavaDialectError;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.memorycompiler.resources.KiePath;
import org.kie.memorycompiler.resources.ResourceStore;

public class PackageStore
implements ResourceStore {
    private JavaDialectRuntimeData javaDialectRuntimeData;
    private List<KnowledgeBuilderResult> errors;

    public PackageStore() {
    }

    public PackageStore(JavaDialectRuntimeData javaDialectRuntimeData, List<KnowledgeBuilderResult> errors) {
        this.javaDialectRuntimeData = javaDialectRuntimeData;
        this.errors = errors;
    }

    public void setPackageCompilationData(JavaDialectRuntimeData javaDialectRuntimeData) {
        this.javaDialectRuntimeData = javaDialectRuntimeData;
    }

    public void write(KiePath resourceName, byte[] clazzData) {
        try {
            this.javaDialectRuntimeData.write(resourceName.asString(), clazzData);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errors.add((KnowledgeBuilderResult)new JavaDialectError("PackageStore was unable to write resourceName='" + resourceName.asString() + "'"));
        }
    }

    public void write(KiePath resourceName, byte[] clazzData, boolean createFolder) {
        this.write(resourceName, clazzData);
    }

    public byte[] read(KiePath resourceName) {
        byte[] clazz = null;
        try {
            clazz = this.javaDialectRuntimeData.read(resourceName.asString());
        }
        catch (Exception e) {
            this.errors.add((KnowledgeBuilderResult)new JavaDialectError("PackageStore was unable to read resourceName='" + resourceName.asString() + "'"));
        }
        return clazz;
    }

    public void remove(KiePath resourceName) {
        try {
            this.javaDialectRuntimeData.remove(resourceName.asString());
        }
        catch (Exception e) {
            this.errors.add((KnowledgeBuilderResult)new JavaDialectError("PackageStore was unable to remove resourceName='" + resourceName.asString() + "'"));
        }
    }
}

