/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.expr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Map;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Enabled;
import org.drools.core.spi.Tuple;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.expr.MVELCompilationUnit;
import org.drools.mvel.expr.MVELCompileable;
import org.drools.mvel.expr.MvelEvaluator;
import org.kie.api.definition.rule.Rule;
import org.mvel2.integration.VariableResolverFactory;

public class MVELEnabledExpression
implements Enabled,
MVELCompileable,
Externalizable {
    private static final long serialVersionUID = 510L;
    private MVELCompilationUnit unit;
    private String id;
    private MvelEvaluator<Boolean> evaluator;

    public MVELEnabledExpression() {
    }

    public MVELEnabledExpression(MVELCompilationUnit unit, String id) {
        this.unit = unit;
        this.id = id;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.unit = (MVELCompilationUnit)in.readObject();
        this.id = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.unit);
        out.writeUTF(this.id);
    }

    public MVELCompilationUnit getMVELCompilationUnit() {
        return this.unit;
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData) {
        this.evaluator = MvelEvaluator.createMvelEvaluator(this.unit.getCompiledExpression(runtimeData));
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData, RuleImpl rule) {
        this.evaluator = MvelEvaluator.createMvelEvaluator(this.unit.getCompiledExpression(runtimeData, (Object)rule.toRuleNameAndPathString()));
    }

    public boolean getValue(Tuple tuple, Declaration[] declarations, RuleImpl rule, ReteEvaluator reteEvaluator) {
        VariableResolverFactory factory = this.unit.getFactory(null, declarations, (Rule)rule, null, tuple, null, reteEvaluator, reteEvaluator.getGlobalResolver());
        InternalKnowledgePackage pkg = reteEvaluator.getKnowledgeBase().getPackage("MAIN");
        if (pkg != null) {
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData(this.id);
            factory.setNextFactory((VariableResolverFactory)data.getFunctionFactory());
        }
        return this.evaluator.evaluate(factory);
    }

    public String toString() {
        return this.unit.getExpression();
    }

    public Declaration[] findDeclarations(Map<String, Declaration> decls) {
        Declaration[] declrs = this.unit.getPreviousDeclarations();
        Declaration[] enabledDeclarations = new Declaration[declrs.length];
        int i = 0;
        for (Declaration declr : declrs) {
            enabledDeclarations[i++] = decls.get(declr.getIdentifier());
        }
        Arrays.sort(enabledDeclarations, RuleTerminalNode.SortDeclarations.instance);
        return enabledDeclarations;
    }
}

