/*
 * Decompiled with CFR 0.152.
 */
package org.drools.metric.util;

import org.drools.core.common.BaseNode;
import org.drools.metric.util.NodeStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricLogUtils {
    private static final Logger logger = LoggerFactory.getLogger(MetricLogUtils.class);
    public static final String METRIC_LOGGER_ENABLED = "drools.metric.logger.enabled";
    private boolean enabled = Boolean.parseBoolean(System.getProperty("drools.metric.logger.enabled", "false"));
    public static final String METRIC_LOGGER_THRESHOLD = "drools.metric.logger.threshold";
    private int threshold = Integer.parseInt(System.getProperty("drools.metric.logger.threshold", "500"));
    private final ThreadLocal<NodeStats> nodeStats = new ThreadLocal();
    private static final MetricLogUtils INSTANCE = new MetricLogUtils();

    public static MetricLogUtils getInstance() {
        return INSTANCE;
    }

    private MetricLogUtils() {
    }

    public int getThreshold() {
        return this.threshold;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void startMetrics(BaseNode baseNode) {
        if (this.enabled) {
            this.nodeStats.set(new NodeStats(baseNode));
        } else {
            logger.warn("Metrics must not be started when disabled");
        }
    }

    public void incrementEvalCount() {
        if (this.enabled) {
            NodeStats stats = this.nodeStats.get();
            if (stats != null && stats.isStarted()) {
                stats.incrementEvalCount();
            }
        } else {
            logger.warn("Metrics must not be excuted when disabled");
        }
    }

    public void logAndEndMetrics() {
        if (this.enabled) {
            NodeStats stats = this.nodeStats.get();
            if (stats != null && stats.isStarted()) {
                long elapsedTimeInMicro = (System.nanoTime() - stats.getStartTime()) / 1000L;
                if (stats.getEvalCount() > 0L && elapsedTimeInMicro > (long)this.threshold) {
                    logger.trace("{}, evalCount:{}, elapsedMicro:{}", new Object[]{stats.getNode(), stats.getEvalCount(), elapsedTimeInMicro});
                }
            } else {
                logger.warn("nodeStats has to be initialized. Call startMetrics() beforehand : stats = {}", (Object)stats);
            }
            this.nodeStats.remove();
        }
    }
}

