/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.debug;

import java.util.Collection;
import org.drools.base.common.NetworkNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.util.FastIterator;
import org.drools.kiesession.debug.AbstractNetworkNodeVisitor;
import org.drools.kiesession.debug.DefaultNodeInfo;
import org.drools.kiesession.debug.StatefulKnowledgeSessionInfo;

public class FromNodeVisitor
extends AbstractNetworkNodeVisitor {
    public static final FromNodeVisitor INSTANCE = new FromNodeVisitor();

    protected FromNodeVisitor() {
    }

    @Override
    protected void doVisit(NetworkNode node, Collection<NetworkNode> nodeStack, StatefulKnowledgeSessionInfo info) {
        FromNode fn = (FromNode)node;
        DefaultNodeInfo ni = info.getNodeInfo(node);
        FromNode.FromMemory memory = (FromNode.FromMemory)info.getSession().getNodeMemory(fn);
        if (fn.isLeftTupleMemoryEnabled()) {
            ni.setTupleMemorySize(memory.getBetaMemory().getLeftTupleMemory().size());
            long handles = 0L;
            FastIterator it = memory.getBetaMemory().getLeftTupleMemory().fullFastIterator();
            TupleImpl leftTuple = memory.getBetaMemory().getLeftTupleMemory().getFirst(null);
            while (leftTuple != null) {
                for (TupleImpl child = leftTuple.getFirstChild(); child != null; child = child.getHandleNext()) {
                    ++handles;
                }
                leftTuple = (TupleImpl)it.next((Object)leftTuple);
            }
            ni.setCreatedFactHandles(handles);
        } else {
            info.warn("The left memory for this node is disabled, making it impossible to calculate the number of created handles");
        }
    }
}

