/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.parser.impl;

import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LiteralExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import java.util.Optional;
import org.drools.impact.analysis.parser.impl.ImpactAnalysisRuleContext;
import org.drools.modelcompiler.builder.generator.RuleContext;

public class ParserUtil {
    public static Object literalToValue(LiteralExpr literalExpr) {
        if (literalExpr instanceof StringLiteralExpr) {
            return literalExpr.asStringLiteralExpr().asString();
        }
        if (literalExpr instanceof IntegerLiteralExpr) {
            return literalExpr.asIntegerLiteralExpr().asInt();
        }
        if (literalExpr instanceof LongLiteralExpr) {
            return literalExpr.asLongLiteralExpr().asLong();
        }
        if (literalExpr instanceof DoubleLiteralExpr) {
            return literalExpr.asDoubleLiteralExpr().asDouble();
        }
        return null;
    }

    public static Class<?> literalType(LiteralExpr literalExpr) {
        if (literalExpr instanceof StringLiteralExpr) {
            return String.class;
        }
        if (literalExpr instanceof IntegerLiteralExpr) {
            return Integer.class;
        }
        if (literalExpr instanceof LongLiteralExpr) {
            return Long.class;
        }
        if (literalExpr instanceof DoubleLiteralExpr) {
            return Double.class;
        }
        return null;
    }

    public static String getLiteralString(RuleContext context, Expression expr) {
        Object value = ParserUtil.getLiteralValue(context, expr);
        return value instanceof String ? (String)value : null;
    }

    public static Object getLiteralValue(RuleContext context, Expression expr) {
        if (expr.isLiteralExpr()) {
            return ParserUtil.literalToValue(expr.asLiteralExpr());
        }
        if (expr.isMethodCallExpr()) {
            MethodCallExpr mce = expr.asMethodCallExpr();
            Optional<SimpleName> optString = mce.getScope().filter(Expression::isNameExpr).map(Expression::asNameExpr).map(NameExpr::getName).filter(name -> name.asString().equals("java.lang.String"));
            if (optString.isPresent() && mce.getName().asString().equals("valueOf")) {
                return ParserUtil.getLiteralValue(context, mce.getArgument(0));
            }
        } else if (expr.isNameExpr()) {
            return ((ImpactAnalysisRuleContext)context).getBindVariableLiteralMap().get(expr.asNameExpr().getNameAsString());
        }
        return null;
    }

    public static boolean isLiteral(Class<?> clazz) {
        return clazz == String.class || clazz == Integer.class || clazz == Long.class || clazz == Double.class;
    }
}

