/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.model.left;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.drools.impact.analysis.model.left.Constraint;

public class Pattern {
    private final Class<?> patternClass;
    private final Collection<Constraint> constraints = new ArrayList<Constraint>();
    private final Collection<String> reactOnFields = new HashSet<String>();
    private final boolean positive;
    private boolean classReactive = false;

    public Pattern(Class<?> patternClass, boolean positive) {
        this.patternClass = patternClass;
        this.positive = positive;
    }

    public Class<?> getPatternClass() {
        return this.patternClass;
    }

    public void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
    }

    public Collection<Constraint> getConstraints() {
        return this.constraints;
    }

    public void addReactOn(String field) {
        this.reactOnFields.add(field);
    }

    public Collection<String> getReactOnFields() {
        return this.reactOnFields;
    }

    public boolean isClassReactive() {
        return this.classReactive;
    }

    public void setClassReactive(boolean classReactive) {
        this.classReactive = classReactive;
    }

    public boolean isPositive() {
        return this.positive;
    }

    public String toString() {
        return "Pattern{patternClass=" + this.patternClass.getCanonicalName() + ", reactOnFields=" + this.reactOnFields + ",\n constraints=" + this.constraints.stream().map(Object::toString).collect(Collectors.joining("\n", ",\n", "")) + '}';
    }
}

