/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.graph.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.Link;
import org.drools.impact.analysis.graph.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphJsonGenerator {
    private static final Logger logger = LoggerFactory.getLogger(GraphJsonGenerator.class);

    private GraphJsonGenerator() {
    }

    public static String generateJson(Graph graph) {
        Map<String, List<Map<String, String>>> map = GraphJsonGenerator.convertToMap(graph);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Map<String, List<Map<String, String>>> convertToMap(Graph graph) {
        HashMap<String, List<Map<String, String>>> map = new HashMap<String, List<Map<String, String>>>();
        ArrayList nodes = new ArrayList();
        ArrayList edges = new ArrayList();
        map.put("NODES", nodes);
        map.put("EDGES", edges);
        for (Node node : graph.getNodeMap().values()) {
            HashMap<String, String> nodeMap = new HashMap<String, String>();
            nodeMap.put("id", node.getId());
            nodeMap.put("type", "node");
            nodeMap.put("label", node.getRuleName());
            nodes.add(nodeMap);
            for (Link outgoingLink : node.getOutgoingLinks()) {
                HashMap<String, Object> edgeMap = new HashMap<String, Object>();
                edgeMap.put("id", "edge-" + node.getId() + "-" + outgoingLink.getTarget().getId());
                edgeMap.put("type", "edge");
                edgeMap.put("source", node.getId());
                edgeMap.put("target", outgoingLink.getTarget().getId());
                switch (outgoingLink.getReactivityType()) {
                    case POSITIVE: {
                        edgeMap.put("edgeStyle", "solid");
                        break;
                    }
                    case NEGATIVE: {
                        edgeMap.put("edgeStyle", "dashed");
                        break;
                    }
                    case UNKNOWN: {
                        edgeMap.put("edgeStyle", "dotted");
                        break;
                    }
                    default: {
                        logger.warn("Unexpected reactivity type: {}", (Object)outgoingLink.getReactivityType());
                        edgeMap.put("edgeStyle", "solid");
                    }
                }
                edges.add(edgeMap);
            }
        }
        return map;
    }
}

