/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.graph;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.drools.impact.analysis.graph.Link;
import org.drools.impact.analysis.graph.ReactivityType;
import org.drools.impact.analysis.model.Rule;

public class Node {
    private String packageName;
    private String ruleName;
    private Optional<Rule> rule;
    protected Status status;
    private Set<Link> incomingLinks;
    private Set<Link> outgoingLinks;

    public Node(Rule rule) {
        this.packageName = rule.getPkg();
        this.ruleName = rule.getName();
        this.rule = Optional.of(rule);
        this.incomingLinks = new HashSet<Link>();
        this.outgoingLinks = new HashSet<Link>();
    }

    public Node(String packageName, String ruleName) {
        this.packageName = packageName;
        this.ruleName = ruleName;
        this.rule = Optional.empty();
        this.incomingLinks = new HashSet<Link>();
        this.outgoingLinks = new HashSet<Link>();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getId() {
        return this.getFqdn();
    }

    public String getFqdn() {
        return this.packageName + "." + this.ruleName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public Optional<Rule> getRule() {
        return this.rule;
    }

    public Set<Link> getIncomingLinks() {
        return this.incomingLinks;
    }

    public Set<Link> getOutgoingLinks() {
        return this.outgoingLinks;
    }

    public static void linkNodes(Node source, Node target, ReactivityType type) {
        Link link = new Link(source, target, type);
        source.getOutgoingLinks().add(link);
        target.getIncomingLinks().add(link);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        result = 31 * result + (this.ruleName == null ? 0 : this.ruleName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName)) {
            return false;
        }
        return !(this.ruleName == null ? other.ruleName != null : !this.ruleName.equals(other.ruleName));
    }

    public String toString() {
        return "Node [packageName=" + this.packageName + ", ruleName=" + this.ruleName + ", outgoingLinks=" + this.outgoingLinks + "]";
    }

    public static enum Status {
        NONE,
        CHANGED,
        IMPACTED;

    }
}

