/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.graph;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.Link;
import org.drools.impact.analysis.graph.Node;

public class TextReporter {
    public static String INDENT = "  ";

    private TextReporter() {
    }

    public static String toFlatText(Graph g) {
        StringBuilder sb = new StringBuilder();
        List keyList = g.getNodeMap().keySet().stream().sorted().collect(Collectors.toList());
        for (String key : keyList) {
            Node node = g.getNodeMap().get(key);
            String ruleName = node.getRuleName();
            sb.append(ruleName);
            String mark = "";
            if (node.getStatus() == Node.Status.CHANGED) {
                mark = "[*]";
            } else if (node.getStatus() == Node.Status.IMPACTED) {
                mark = "[+]";
            }
            sb.append(mark);
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public static String toHierarchyText(Graph g) {
        StringBuilder sb = new StringBuilder();
        List keyList = g.getNodeMap().keySet().stream().sorted().collect(Collectors.toList());
        HashSet<Node> pickedNodeSet = new HashSet<Node>();
        for (String key : keyList) {
            Node node = g.getNodeMap().get(key);
            if (pickedNodeSet.contains(node)) continue;
            TextReporter.addNode(node, "", pickedNodeSet, sb);
        }
        return sb.toString();
    }

    private static void addNode(Node node, String indent, Set<Node> pickedNodeSet, StringBuilder sb) {
        sb.append(indent);
        String ruleName = node.getRuleName();
        sb.append(ruleName);
        String mark = "";
        if (node.getStatus() == Node.Status.CHANGED) {
            mark = "[*]";
        } else if (node.getStatus() == Node.Status.IMPACTED) {
            mark = "[+]";
        }
        sb.append(mark);
        sb.append(System.lineSeparator());
        pickedNodeSet.add(node);
        for (Link link : node.getOutgoingLinks()) {
            Node target = link.getTarget();
            if (pickedNodeSet.contains(target)) {
                TextReporter.addNodeWithoutCircular(target, indent + INDENT, sb);
                continue;
            }
            TextReporter.addNode(target, indent + INDENT, pickedNodeSet, sb);
        }
    }

    private static void addNodeWithoutCircular(Node node, String indent, StringBuilder sb) {
        sb.append(indent);
        sb.append("(" + node.getRuleName() + ")" + System.lineSeparator());
    }
}

