/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.graph;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.impact.analysis.graph.AnalyzedRule;
import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.GraphAnalysis;
import org.drools.impact.analysis.graph.Node;
import org.drools.impact.analysis.graph.ReactivityType;
import org.drools.impact.analysis.model.AnalysisModel;
import org.drools.impact.analysis.model.Package;
import org.drools.impact.analysis.model.Rule;
import org.drools.impact.analysis.model.left.Constraint;
import org.drools.impact.analysis.model.left.LeftHandSide;
import org.drools.impact.analysis.model.left.Pattern;
import org.drools.impact.analysis.model.right.ConsequenceAction;
import org.drools.impact.analysis.model.right.InsertAction;
import org.drools.impact.analysis.model.right.InsertedProperty;
import org.drools.impact.analysis.model.right.ModifiedProperty;
import org.drools.impact.analysis.model.right.ModifyAction;
import org.drools.impact.analysis.model.right.RightHandSide;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelToGraphConverter {
    private static Logger logger = LoggerFactory.getLogger(ModelToGraphConverter.class);
    private boolean positiveOnly = false;

    public ModelToGraphConverter() {
    }

    public ModelToGraphConverter(boolean positiveOnly) {
        this.positiveOnly = positiveOnly;
    }

    public Graph toGraph(AnalysisModel model) {
        GraphAnalysis graphAnalysis = this.generateGraphAnalysis(model);
        this.parseGraphAnalysis(model, graphAnalysis);
        return new Graph(graphAnalysis.getNodeMap());
    }

    private GraphAnalysis generateGraphAnalysis(AnalysisModel model) {
        GraphAnalysis graphAnalysis = new GraphAnalysis();
        for (Package pkg : model.getPackages()) {
            List rules = pkg.getRules();
            for (Rule rule : rules) {
                graphAnalysis.addNode(new Node(rule));
                LeftHandSide lhs = rule.getLhs();
                List patterns = lhs.getPatterns();
                for (Pattern pattern : patterns) {
                    Class patternClass = pattern.getPatternClass();
                    Collection reactOnFields = pattern.getReactOnFields();
                    if (pattern.isClassReactive()) {
                        graphAnalysis.addClassReactiveRule(patternClass, rule, pattern.isPositive());
                        continue;
                    }
                    if (reactOnFields.size() == 0) {
                        graphAnalysis.addInsertReactiveRule(patternClass, rule, pattern.isPositive());
                        continue;
                    }
                    for (String field : reactOnFields) {
                        graphAnalysis.addPropertyReactiveRule(patternClass, field, rule, pattern.isPositive());
                    }
                }
            }
        }
        return graphAnalysis;
    }

    private void parseGraphAnalysis(AnalysisModel model, GraphAnalysis graphAnalysis) {
        for (Package pkg : model.getPackages()) {
            String pkgName = pkg.getName();
            List rules = pkg.getRules();
            for (Rule rule : rules) {
                String ruleName = rule.getName();
                RightHandSide rhs = rule.getRhs();
                List actions = rhs.getActions();
                for (ConsequenceAction action : actions) {
                    switch (action.getType()) {
                        case INSERT: {
                            this.processInsert(graphAnalysis, pkgName, ruleName, (InsertAction)action);
                            break;
                        }
                        case DELETE: {
                            this.processDelete(graphAnalysis, pkgName, ruleName, action);
                            break;
                        }
                        case MODIFY: {
                            this.processModify(graphAnalysis, pkgName, ruleName, (ModifyAction)action);
                        }
                    }
                }
            }
        }
    }

    private void processInsert(GraphAnalysis graphAnalysis, String pkgName, String ruleName, InsertAction action) {
        Node source = graphAnalysis.getNode(ModelToGraphConverter.fqdn(pkgName, ruleName));
        Class insertedClass = action.getActionClass();
        if (!graphAnalysis.isRegisteredClass(insertedClass)) {
            logger.warn("Not found " + insertedClass + " in reactiveMap");
            return;
        }
        List insertedProperties = action.getInsertedProperties();
        for (InsertedProperty insertedProperty : insertedProperties) {
            String property = insertedProperty.getProperty();
            for (AnalyzedRule reactedRule : graphAnalysis.getRulesReactiveTo(insertedClass, property)) {
                List patterns = reactedRule.getRule().getLhs().getPatterns().stream().filter(pattern -> pattern.getPatternClass() == insertedClass).collect(Collectors.toList());
                for (Pattern pattern2 : patterns) {
                    List constraints = pattern2.getConstraints().stream().filter(constraint -> constraint.getProperty() != null && constraint.getProperty().equals(property)).collect(Collectors.toList());
                    ReactivityType combinedLinkType = ReactivityType.UNKNOWN;
                    if (constraints.size() == 0) {
                        combinedLinkType = ReactivityType.UNKNOWN;
                    } else {
                        for (Constraint constraint2 : constraints) {
                            ReactivityType linkType = this.linkType(constraint2, (ModifiedProperty)insertedProperty);
                            if (linkType == ReactivityType.POSITIVE) {
                                combinedLinkType = ReactivityType.POSITIVE;
                                break;
                            }
                            if (linkType == ReactivityType.NEGATIVE) {
                                combinedLinkType = ReactivityType.NEGATIVE;
                                continue;
                            }
                            if (combinedLinkType == ReactivityType.NEGATIVE && linkType == ReactivityType.UNKNOWN) continue;
                            combinedLinkType = linkType;
                        }
                    }
                    if (combinedLinkType == ReactivityType.NEGATIVE) continue;
                    if (combinedLinkType == ReactivityType.POSITIVE && !pattern2.isPositive()) {
                        combinedLinkType = combinedLinkType.negate();
                    }
                    Node target = graphAnalysis.getNode(ModelToGraphConverter.fqdn(pkgName, reactedRule.getRule().getName()));
                    this.linkNodesIfExpected(source, target, combinedLinkType);
                }
            }
        }
        for (AnalyzedRule reactedRule : graphAnalysis.getRulesReactiveToWithoutProperty(insertedClass)) {
            Node target = graphAnalysis.getNode(ModelToGraphConverter.fqdn(pkgName, reactedRule.getRule().getName()));
            this.linkNodesIfExpected(source, target, reactedRule.getReactivityType());
        }
    }

    private void processDelete(GraphAnalysis graphAnalysis, String pkgName, String ruleName, ConsequenceAction action) {
        Class deletedClass = action.getActionClass();
        Node source = graphAnalysis.getNode(ModelToGraphConverter.fqdn(pkgName, ruleName));
        for (AnalyzedRule reactedRule : graphAnalysis.getRulesReactiveTo(deletedClass)) {
            Node target = graphAnalysis.getNode(ModelToGraphConverter.fqdn(pkgName, reactedRule.getRule().getName()));
            this.linkNodesIfExpected(source, target, reactedRule.getReactivityType().negate());
        }
    }

    private void processModify(GraphAnalysis graphAnalysis, String pkgName, String ruleName, ModifyAction action) {
        Node source = graphAnalysis.getNode(ModelToGraphConverter.fqdn(pkgName, ruleName));
        Class modifiedClass = action.getActionClass();
        if (!graphAnalysis.isRegisteredClass(modifiedClass)) {
            logger.warn("Not found " + modifiedClass + " in reactiveMap");
            return;
        }
        List modifiedProperties = action.getModifiedProperties();
        for (ModifiedProperty modifiedProperty : modifiedProperties) {
            String property = modifiedProperty.getProperty();
            for (AnalyzedRule reactedRule : graphAnalysis.getRulesReactiveTo(modifiedClass, property)) {
                List constraints = reactedRule.getRule().getLhs().getPatterns().stream().filter(pattern -> pattern.getPatternClass() == modifiedClass).flatMap(pattern -> pattern.getConstraints().stream()).filter(constraint -> constraint.getProperty() != null && constraint.getProperty().equals(property)).collect(Collectors.toList());
                ReactivityType combinedLinkType = ReactivityType.UNKNOWN;
                if (constraints.size() == 0) {
                    combinedLinkType = ReactivityType.UNKNOWN;
                } else {
                    for (Constraint constraint2 : constraints) {
                        ReactivityType linkType = this.linkType(constraint2, modifiedProperty);
                        if (linkType == ReactivityType.POSITIVE) {
                            combinedLinkType = ReactivityType.POSITIVE;
                            break;
                        }
                        if (linkType == ReactivityType.NEGATIVE) {
                            combinedLinkType = ReactivityType.NEGATIVE;
                            continue;
                        }
                        if (combinedLinkType == ReactivityType.NEGATIVE && linkType == ReactivityType.UNKNOWN) continue;
                        combinedLinkType = linkType;
                    }
                }
                if (reactedRule.getReactivityType() == ReactivityType.NEGATIVE) {
                    combinedLinkType = combinedLinkType.negate();
                }
                Node target = graphAnalysis.getNode(ModelToGraphConverter.fqdn(pkgName, reactedRule.getRule().getName()));
                this.linkNodesIfExpected(source, target, combinedLinkType);
            }
        }
    }

    private void linkNodesIfExpected(Node source, Node target, ReactivityType type) {
        if (!this.positiveOnly || type == ReactivityType.POSITIVE) {
            Node.linkNodes(source, target, type);
        }
    }

    private ReactivityType linkType(Constraint constraint, ModifiedProperty modifiedProperty) {
        Object value = constraint.getValue();
        Object modifiedValue = modifiedProperty.getValue();
        if (modifiedValue == null || value == null) {
            return ReactivityType.UNKNOWN;
        }
        if (value instanceof Number && modifiedValue instanceof Number) {
            value = ((Number)value).doubleValue();
            modifiedValue = ((Number)modifiedValue).doubleValue();
        }
        switch (constraint.getType()) {
            case EQUAL: {
                if (modifiedValue.equals(value)) {
                    return ReactivityType.POSITIVE;
                }
                return ReactivityType.NEGATIVE;
            }
            case NOT_EQUAL: {
                if (!modifiedValue.equals(value)) {
                    return ReactivityType.POSITIVE;
                }
                return ReactivityType.NEGATIVE;
            }
            case GREATER_THAN: {
                if (((Comparable)modifiedValue).compareTo((Comparable)value) > 0) {
                    return ReactivityType.POSITIVE;
                }
                return ReactivityType.NEGATIVE;
            }
            case GREATER_OR_EQUAL: {
                if (((Comparable)modifiedValue).compareTo((Comparable)value) >= 0) {
                    return ReactivityType.POSITIVE;
                }
                return ReactivityType.NEGATIVE;
            }
            case LESS_THAN: {
                if (((Comparable)modifiedValue).compareTo((Comparable)value) < 0) {
                    return ReactivityType.POSITIVE;
                }
                return ReactivityType.NEGATIVE;
            }
            case LESS_OR_EQUAL: {
                if (((Comparable)modifiedValue).compareTo((Comparable)value) <= 0) {
                    return ReactivityType.POSITIVE;
                }
                return ReactivityType.NEGATIVE;
            }
            case RANGE: {
                break;
            }
        }
        return ReactivityType.UNKNOWN;
    }

    private static String fqdn(String packageName, String ruleName) {
        return packageName + "." + ruleName;
    }
}

