/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.Link;
import org.drools.impact.analysis.graph.Node;
import org.drools.impact.analysis.graph.ReactivityType;

public class ImpactAnalysisHelper {
    private boolean positiveOnly = false;

    public ImpactAnalysisHelper() {
    }

    public ImpactAnalysisHelper(boolean positiveOnly) {
        this.positiveOnly = positiveOnly;
    }

    public Graph filterImpactedNodes(Graph graph, String changedNodeName) {
        Node changedNode = graph.getNodeMap().get(changedNodeName);
        if (changedNode == null) {
            throw new RuntimeException("Cannot find a node : name = " + changedNodeName);
        }
        return this.filterImpactedNodes(graph, changedNode);
    }

    public Graph filterImpactedNodes(Graph graph, Node changedNode) {
        HashSet<Node> impactedNodes = new HashSet<Node>();
        this.collectImpactedNodes(changedNode, impactedNodes);
        changedNode.setStatus(Node.Status.CHANGED);
        Map<String, Node> nodeMap = graph.getNodeMap();
        Map<String, Node> subMap = this.getSubMap(nodeMap, impactedNodes);
        return new Graph(subMap);
    }

    private void collectImpactedNodes(Node changedNode, Collection<Node> impactedNodes) {
        changedNode.setStatus(Node.Status.IMPACTED);
        impactedNodes.add(changedNode);
        changedNode.getOutgoingLinks().stream().filter(link -> !this.positiveOnly || this.positiveOnly && link.getReactivityType() == ReactivityType.POSITIVE).map(Link::getTarget).filter(node -> !impactedNodes.contains(node)).forEach(node -> this.collectImpactedNodes((Node)node, impactedNodes));
    }

    private Map<String, Node> getSubMap(Map<String, Node> nodeMap, Collection<Node> impactedNodes) {
        HashMap<String, Node> subMap = new HashMap<String, Node>();
        impactedNodes.stream().map(node -> node.getId()).forEach(id -> {
            Node cfr_ignored_0 = (Node)subMap.put((String)id, (Node)nodeMap.get(id));
        });
        return subMap;
    }
}

