/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.birdsfly;

import java.util.Scanner;
import org.drools.examples.birdsfly.Bird;
import org.drools.examples.birdsfly.Broken;
import org.drools.examples.birdsfly.Rocket;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

public class BirdsFlyExample {
    public static void main(String[] args) {
        KieSession ksession;
        try {
            System.setProperty("drools.negatable", "on");
            KieContainer kc = KieServices.Factory.get().getKieClasspathContainer();
            ksession = kc.newKieSession("BirdsFlyKS");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            System.setProperty("drools.negatable", "off");
        }
        Bird d1 = new Bird("D1", "Dove");
        ksession.insert((Object)d1);
        ksession.fireAllRules();
        BirdsFlyExample.pause();
        Bird d2 = new Bird("D2", "Dove");
        ksession.insert((Object)d2);
        Broken broken1 = new Broken(d2, "wing");
        ksession.insert((Object)broken1);
        ksession.fireAllRules();
        BirdsFlyExample.pause();
        Bird p1 = new Bird("P1", "Penguin");
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        BirdsFlyExample.pause();
        Bird p2 = new Bird("P2", "Penguin");
        ksession.insert((Object)p2);
        Rocket r1 = new Rocket(p2);
        ksession.insert((Object)r1);
        ksession.fireAllRules();
        ksession.dispose();
    }

    public static void pause() {
        System.out.println("Pressure enter to continue");
        Scanner keyboard = new Scanner(System.in);
        keyboard.nextLine();
    }
}

