/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferStrategy;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.drools.games.GameConfiguration;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;

public class GameUI
extends Canvas {
    private GameConfiguration conf;
    private JFrame frame;
    private JPanel panel;
    private BufferStrategy bufferStrategy;
    private Graphics2D graphics;
    KieSession ksession;

    public GameUI(KieSession ksession, GameConfiguration conf) {
        this.ksession = ksession;
        this.conf = conf;
    }

    public void init() {
        this.frame = new JFrame("Drools Example");
        this.frame.setDefaultCloseOperation(this.conf.isExitOnClose() ? 3 : 2);
        this.frame.setResizable(false);
        this.frame.setBackground(Color.BLACK);
        this.frame.getContentPane().setBackground(Color.BLACK);
        this.panel = (JPanel)this.frame.getContentPane();
        this.panel.setPreferredSize(new Dimension(this.conf.getWindowWidth(), this.conf.getWindowHeight()));
        this.panel.setLayout(null);
        this.setBounds(0, 0, this.conf.getWindowWidth(), this.conf.getWindowHeight());
        this.panel.add(this);
        this.setIgnoreRepaint(true);
        GameKeyListener klistener = new GameKeyListener(this.ksession.getEntryPoint("KeyPressedStream"), this.ksession.getEntryPoint("KeyReleasedStream"));
        this.addKeyListener(klistener);
        this.frame.setLocationRelativeTo(null);
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setVisible(true);
        this.createBufferStrategy(2);
        this.bufferStrategy = this.getBufferStrategy();
    }

    public JPanel getCanvas() {
        return this.panel;
    }

    @Override
    public Graphics getGraphics() {
        if (this.graphics == null) {
            this.graphics = (Graphics2D)this.bufferStrategy.getDrawGraphics();
        }
        return this.graphics;
    }

    public void disposeGraphics() {
        if (this.graphics != null) {
            this.graphics.dispose();
        }
        this.graphics = null;
    }

    @Override
    public void repaint() {
        this.getBufferStrategy().show();
        this.disposeGraphics();
    }

    public static class GameKeyListener
    extends KeyAdapter {
        EntryPoint keyPressedEntryPoint;
        EntryPoint keyReleasedEntryPoint;

        public GameKeyListener(EntryPoint keyPressedEntryPoint, EntryPoint keyReleasedEntryPoint) {
            this.keyPressedEntryPoint = keyPressedEntryPoint;
            this.keyReleasedEntryPoint = keyReleasedEntryPoint;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.keyPressedEntryPoint.insert((Object)e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.keyReleasedEntryPoint.insert((Object)e);
        }
    }
}

