/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.sudoku;

import java.util.Formatter;
import java.util.HashSet;
import java.util.Set;
import org.drools.examples.sudoku.Cell;
import org.drools.examples.sudoku.CellCol;
import org.drools.examples.sudoku.CellGroup;
import org.drools.examples.sudoku.CellRow;
import org.drools.examples.sudoku.CellSqr;
import org.drools.examples.sudoku.Counter;
import org.drools.examples.sudoku.Setting;
import org.drools.examples.sudoku.Stepping;
import org.drools.examples.sudoku.swing.AbstractSudokuGridModel;
import org.drools.examples.sudoku.swing.SudokuGridEvent;
import org.drools.examples.sudoku.swing.SudokuGridModel;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

public class Sudoku
extends AbstractSudokuGridModel
implements SudokuGridModel {
    public static Sudoku sudoku;
    public Cell[][] cells;
    private CellSqr[][] sqrs = new CellSqr[][]{new CellSqr[3], new CellSqr[3], new CellSqr[3]};
    private CellRow[] rows = new CellRow[9];
    private CellCol[] cols = new CellCol[9];
    private KieContainer kc;
    private KieSession session;
    private SudokuWorkingMemoryListener workingMemoryListener = new SudokuWorkingMemoryListener();
    private Counter counter;
    private Boolean explain = false;
    private FactHandle steppingFactHandle;
    private Stepping stepping;
    private boolean unsolvable = false;

    public Sudoku(KieContainer kc) {
        this.kc = kc;
        sudoku = this;
    }

    @Override
    public String getCellValue(int iRow, int iCol) {
        if (this.cells == null) {
            return " ";
        }
        return this.cells[iRow][iCol].valueAsString();
    }

    public void dumpGrid() {
        Formatter fmt = new Formatter(System.out);
        fmt.format("       ", new Object[0]);
        for (int iCol = 0; iCol < 9; ++iCol) {
            fmt.format("Col: %d     ", iCol);
        }
        System.out.println();
        for (int iRow = 0; iRow < 9; ++iRow) {
            System.out.print("Row " + iRow + ": ");
            for (int iCol = 0; iCol < 9; ++iCol) {
                if (this.cells[iRow][iCol].getValue() != null) {
                    fmt.format(" --- %d --- ", this.cells[iRow][iCol].getValue());
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                Set<Integer> perms = this.cells[iRow][iCol].getFree();
                for (int i = 1; i <= 9; ++i) {
                    if (perms.contains(i)) {
                        sb.append(i);
                        continue;
                    }
                    sb.append(' ');
                }
                fmt.format(" %-10s", sb.toString());
            }
            System.out.println();
        }
        fmt.close();
    }

    public void consistencyCheck() {
        Integer value;
        Cell cell;
        int i;
        for (int iRow = 0; iRow < 9; ++iRow) {
            for (int iCol = 0; iCol < 9; ++iCol) {
                Cell cell2 = this.cells[iRow][iCol];
                Integer value2 = cell2.getValue();
                if (value2 == null) continue;
                if (!cell2.getFree().isEmpty()) {
                    throw new IllegalStateException("free not empty");
                }
                for (Cell other : cell2.getExCells()) {
                    if (value2.equals(other.getValue())) {
                        throw new IllegalStateException("duplicate");
                    }
                    if (!other.getFree().contains(value2)) continue;
                    throw new IllegalStateException("not eliminated");
                }
            }
        }
        for (i = 0; i < this.rows.length; ++i) {
            HashSet<Integer> aSet = new HashSet<Integer>();
            for (int j = 0; j < this.rows[i].getCells().size(); ++j) {
                cell = this.rows[i].getCells().get(j);
                value = cell.getValue();
                if (value != null) {
                    aSet.add(value);
                    continue;
                }
                aSet.addAll(cell.getFree());
            }
            if (((Object)aSet).equals(CellGroup.ALL_NINE)) continue;
            throw new IllegalStateException("deficit in row");
        }
        for (i = 0; i < this.cols.length; ++i) {
            HashSet<Integer> aSet = new HashSet<Integer>();
            for (int j = 0; j < this.cols[i].getCells().size(); ++j) {
                cell = this.cols[i].getCells().get(j);
                value = cell.getValue();
                if (value != null) {
                    aSet.add(value);
                    continue;
                }
                aSet.addAll(cell.getFree());
            }
            if (((Object)aSet).equals(CellGroup.ALL_NINE)) continue;
            throw new IllegalStateException("deficit in column");
        }
        for (int ir = 0; ir < this.sqrs.length; ++ir) {
            for (int ic = 0; ic < this.sqrs[ir].length; ++ic) {
                HashSet<Integer> aSet = new HashSet<Integer>();
                for (int j = 0; j < this.sqrs[ir][ic].getCells().size(); ++j) {
                    Cell cell3 = this.sqrs[ir][ic].getCells().get(j);
                    Integer value3 = cell3.getValue();
                    if (value3 != null) {
                        aSet.add(value3);
                        continue;
                    }
                    aSet.addAll(cell3.getFree());
                }
                if (((Object)aSet).equals(CellGroup.ALL_NINE)) continue;
                throw new IllegalStateException("deficit in square");
            }
        }
        System.out.println("+++ check OK +++");
    }

    @Override
    public void solve() {
        if (this.isSolved()) {
            return;
        }
        this.explain = false;
        this.session.setGlobal("explain", (Object)this.explain);
        if (this.steppingFactHandle != null) {
            this.session.delete(this.steppingFactHandle);
            this.steppingFactHandle = null;
            this.stepping = null;
        }
        this.session.fireAllRules();
    }

    @Override
    public void step() {
        if (this.isSolved()) {
            return;
        }
        this.explain = true;
        this.session.setGlobal("explain", (Object)this.explain);
        this.counter.setCount(1);
        this.session.update(this.session.getFactHandle((Object)this.counter), (Object)this.counter);
        if (this.steppingFactHandle == null) {
            this.stepping = new Stepping();
            this.steppingFactHandle = this.session.insert((Object)this.stepping);
        }
        this.session.fireUntilHalt();
        if (this.stepping.isEmergency()) {
            this.unsolvable = true;
        }
    }

    public boolean isSolved() {
        for (int iRow = 0; iRow < 9; ++iRow) {
            for (int iCol = 0; iCol < 9; ++iCol) {
                if (this.cells[iRow][iCol].getValue() != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUnsolvable() {
        return this.unsolvable;
    }

    private void create() {
        int iCol;
        int iRow;
        int i;
        for (i = 0; i < 9; ++i) {
            this.session.insert((Object)(i + 1));
            this.rows[i] = new CellRow(i);
            this.cols[i] = new CellCol(i);
        }
        this.cells = new Cell[9][];
        for (iRow = 0; iRow < 9; ++iRow) {
            this.cells[iRow] = new Cell[9];
            for (iCol = 0; iCol < 9; ++iCol) {
                Cell cell = new Cell();
                this.cells[iRow][iCol] = cell;
                Cell cell2 = cell;
                this.rows[iRow].addCell(cell2);
                this.cols[iCol].addCell(cell2);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.sqrs[i][j] = new CellSqr(this.rows[i * 3], this.rows[i * 3 + 1], this.rows[i * 3 + 2], this.cols[j * 3], this.cols[j * 3 + 1], this.cols[j * 3 + 2]);
            }
        }
        for (iRow = 0; iRow < 9; ++iRow) {
            for (iCol = 0; iCol < 9; ++iCol) {
                this.cells[iRow][iCol].makeReferences(this.rows[iRow], this.cols[iCol], this.sqrs[iRow / 3][iCol / 3]);
                this.session.insert((Object)this.cells[iRow][iCol]);
            }
            this.session.insert((Object)this.rows[iRow]);
            this.session.insert((Object)this.cols[iRow]);
            this.session.insert((Object)this.sqrs[iRow / 3][iRow % 3]);
        }
    }

    @Override
    public void setCellValues(Integer[][] cellValues) {
        if (this.session != null) {
            this.session.removeEventListener((RuleRuntimeEventListener)this.workingMemoryListener);
            this.session.dispose();
            this.steppingFactHandle = null;
        }
        this.session = this.kc.newKieSession("SudokuKS");
        this.session.setGlobal("explain", (Object)this.explain);
        this.session.addEventListener((RuleRuntimeEventListener)this.workingMemoryListener);
        Setting s000 = new Setting(0, 0, 0);
        FactHandle fh000 = this.session.insert((Object)s000);
        this.create();
        int initial = 0;
        for (int iRow = 0; iRow < 9; ++iRow) {
            for (int iCol = 0; iCol < 9; ++iCol) {
                Integer value = cellValues[iRow][iCol];
                if (value == null) continue;
                this.session.insert((Object)new Setting(iRow, iCol, value));
                ++initial;
            }
        }
        this.counter = new Counter(initial);
        this.session.insert((Object)this.counter);
        this.session.delete(fh000);
        this.session.fireAllRules();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sudoku:").append('\n');
        for (int iRow = 0; iRow < 9; ++iRow) {
            sb.append("  ").append(this.rows[iRow].toString()).append('\n');
        }
        return sb.toString();
    }

    public void validate() {
        this.session.getAgenda().getAgendaGroup("validate").setFocus();
        this.session.fireUntilHalt();
    }

    class SudokuWorkingMemoryListener
    implements RuleRuntimeEventListener {
        SudokuWorkingMemoryListener() {
        }

        public void objectInserted(ObjectInsertedEvent ev) {
            if (ev.getObject() instanceof Counter) {
                Sudoku.this.fireRestartEvent(null);
            }
        }

        public void objectDeleted(ObjectDeletedEvent ev) {
        }

        public void objectUpdated(ObjectUpdatedEvent ev) {
            Cell cell;
            if (ev.getObject() instanceof Cell && (cell = (Cell)ev.getObject()).getValue() != null) {
                Sudoku.this.fireCellUpdatedEvent(new SudokuGridEvent(this, cell.getRowNo(), cell.getColNo(), cell.getValue()));
            }
        }
    }
}

