/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.pacman;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.drools.runtime.ExitPoint;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;

public class PacmanGui
extends JFrame
implements KeyListener,
ActionListener {
    JTextArea displayArea;
    static final String newline = System.getProperty("line.separator");
    WorkingMemoryEntryPoint keyListenerEntryPoint;

    public static void createAndShowGUI(StatefulKnowledgeSession ksession) {
        PacmanGui frame = new PacmanGui("KeyEventDemo", ksession);
        frame.setDefaultCloseOperation(3);
        frame.addComponentsToPane();
        frame.pack();
        frame.setVisible(true);
    }

    public void appendText(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PacmanGui.this.displayArea.append(string);
                PacmanGui.this.displayArea.setCaretPosition(PacmanGui.this.displayArea.getDocument().getLength());
            }
        });
    }

    private void addComponentsToPane() {
        this.getContentPane().add((Component)new JLabel("Press an arrow key to start the key event output."), "North");
        this.displayArea = new JTextArea();
        this.displayArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.displayArea);
        scrollPane.setPreferredSize(new Dimension(600, 600));
        this.displayArea.addKeyListener(this);
        this.getContentPane().add((Component)scrollPane, "Center");
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(this);
        this.getContentPane().add((Component)clearButton, "Last");
    }

    public PacmanGui(String name, StatefulKnowledgeSession ksession) {
        super(name);
        this.keyListenerEntryPoint = ksession.getWorkingMemoryEntryPoint("KeyListener");
        ksession.registerExitPoint("ConsoleExitPoint", (ExitPoint)new ConsoleExitPoint(this));
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.keyListenerEntryPoint.insert((Object)e);
    }

    public void actionPerformed(ActionEvent e) {
        this.displayArea.setText("");
    }

    public static class ConsoleExitPoint
    implements ExitPoint {
        private PacmanGui gui;

        public ConsoleExitPoint(PacmanGui gui) {
            this.gui = gui;
        }

        public void insert(Object arg) {
            this.gui.appendText((String)arg);
        }
    }
}

