/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.util.ArrayList;
import org.drools.base.rule.IndexableConstraint;
import org.drools.base.rule.constraint.BetaNodeFieldConstraint;
import org.drools.base.util.FieldIndex;
import org.drools.base.util.index.ConstraintTypeOperator;
import org.drools.base.util.index.IndexUtil;
import org.drools.core.RuleBaseConfiguration;
import org.kie.internal.conf.IndexPrecedenceOption;

public class IndexSpec {
    private ConstraintTypeOperator constraintType = ConstraintTypeOperator.UNKNOWN;
    private FieldIndex[] indexes;

    IndexSpec(short nodeType, BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration config) {
        this.init(nodeType, constraints, config);
    }

    public ConstraintTypeOperator getConstraintType() {
        return this.constraintType;
    }

    public FieldIndex[] getIndexes() {
        return this.indexes;
    }

    public FieldIndex getIndex(int pos) {
        return this.indexes[pos];
    }

    private void init(short nodeType, BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration config) {
        int firstIndexableConstraint;
        int keyDepth = config.getCompositeKeyDepth();
        IndexPrecedenceOption indexPrecedenceOption = config.getIndexPrecedenceOption();
        int n = firstIndexableConstraint = indexPrecedenceOption == IndexPrecedenceOption.EQUALITY_PRIORITY ? this.determineTypeWithEqualityPriority(nodeType, constraints, config) : this.determineTypeWithPatternOrder(nodeType, constraints, config);
        if (this.constraintType == ConstraintTypeOperator.EQUAL) {
            ArrayList<FieldIndex> indexList = new ArrayList<FieldIndex>();
            if (IndexUtil.isEqualIndexable(constraints[firstIndexableConstraint])) {
                indexList.add(((IndexableConstraint)((Object)constraints[firstIndexableConstraint])).getFieldIndex());
            }
            for (int i = firstIndexableConstraint + 1; i < constraints.length && indexList.size() < keyDepth; ++i) {
                if (!IndexUtil.isEqualIndexable(constraints[i]) || ((IndexableConstraint)((Object)constraints[i])).isUnification()) continue;
                indexList.add(((IndexableConstraint)((Object)constraints[i])).getFieldIndex());
            }
            this.indexes = indexList.toArray(new FieldIndex[indexList.size()]);
        } else if (this.constraintType.isComparison()) {
            this.indexes = new FieldIndex[]{((IndexableConstraint)((Object)constraints[firstIndexableConstraint])).getFieldIndex()};
        }
    }

    private int determineTypeWithEqualityPriority(short nodeType, BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration config) {
        int indexedConstraintPos = 0;
        for (int i = 0; i < constraints.length; ++i) {
            if (!(constraints[i] instanceof IndexableConstraint)) continue;
            IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)constraints[i]);
            ConstraintTypeOperator type = indexableConstraint.getConstraintType();
            if (type == ConstraintTypeOperator.EQUAL) {
                this.constraintType = type;
                return i;
            }
            if (this.constraintType != ConstraintTypeOperator.UNKNOWN || !type.isIndexableForNode(nodeType, indexableConstraint, config)) continue;
            this.constraintType = type;
            indexedConstraintPos = i;
        }
        return indexedConstraintPos;
    }

    private int determineTypeWithPatternOrder(short nodeType, BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration config) {
        for (int i = 0; i < constraints.length; ++i) {
            ConstraintTypeOperator type = ConstraintTypeOperator.getType(constraints[i]);
            if (!type.isIndexableForNode(nodeType, (IndexableConstraint)((Object)constraints[i]), config)) continue;
            this.constraintType = type;
            return i;
        }
        return constraints.length;
    }
}

