/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.drools.base.base.ObjectType;
import org.drools.base.common.RuleBasePartitionId;
import org.drools.base.reteoo.NodeTypeEnums;
import org.drools.base.reteoo.PropertySpecificUtil;
import org.drools.base.rule.IndexableConstraint;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.constraint.BetaNodeFieldConstraint;
import org.drools.base.util.index.IndexUtil;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.DoubleBetaConstraints;
import org.drools.core.common.DoubleNonIndexSkipBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.QuadroupleBetaConstraints;
import org.drools.core.common.QuadroupleNonIndexSkipBetaConstraints;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.SingleBetaConstraints;
import org.drools.core.common.SingleNonIndexSkipBetaConstraints;
import org.drools.core.common.TripleBetaConstraints;
import org.drools.core.common.TripleNonIndexSkipBetaConstraints;
import org.drools.core.common.TupleSets;
import org.drools.core.common.UpdateContext;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.phreak.TupleEvaluationUtil;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.reteoo.RightTupleSink;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.SubnetworkTuple;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.util.FastIterator;
import org.drools.util.bitmask.AllSetBitMask;
import org.drools.util.bitmask.BitMask;
import org.drools.util.bitmask.EmptyBitMask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BetaNode
extends LeftTupleSource
implements LeftTupleSinkNode,
ObjectSinkNode,
RightTupleSink,
MemoryFactory {
    protected static final Logger log = LoggerFactory.getLogger(BetaNode.class);
    protected static final boolean isLogTraceEnabled = log.isTraceEnabled();
    protected ObjectSource rightInput;
    protected BetaConstraints constraints;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private ObjectSinkNode previousObjectSinkNode;
    private ObjectSinkNode nextObjectSinkNode;
    protected boolean objectMemory = true;
    protected boolean tupleMemoryEnabled;
    protected boolean indexedUnificationJoin;
    private BitMask rightDeclaredMask = EmptyBitMask.get();
    private BitMask rightInferredMask = EmptyBitMask.get();
    private BitMask rightNegativeMask = EmptyBitMask.get();
    private Collection<String> leftListenedProperties;
    private Collection<String> rightListenedProperties;
    private transient ObjectTypeNode.Id rightInputOtnId = ObjectTypeNode.DEFAULT_ID;
    protected boolean rightInputIsRiaNode;
    private transient ObjectTypeNode objectTypeNode;
    private boolean rightInputIsPassive;
    private boolean indexable;

    public BetaNode() {
    }

    protected BetaNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints constraints, BuildContext context) {
        super(id, context);
        this.setLeftTupleSource(leftInput);
        this.rightInput = rightInput;
        this.rightInputIsRiaNode = 71 == rightInput.getType();
        this.setConstraints(constraints);
        if (this.constraints == null) {
            throw new RuntimeException("cannot have null constraints, must at least be an instance of EmptyBetaConstraints");
        }
        this.constraints.init(context, this.getType());
        this.constraints.registerEvaluationContext(context);
        this.initMasks(context, leftInput);
        this.setStreamMode(context.isStreamMode() && this.getObjectTypeNode(context).getObjectType().isEvent());
        this.hashcode = this.calculateHashCode();
        this.indexable = this.constraints.getConstraints().length > 0 && IndexUtil.isIndexable(this.constraints.getConstraints()[0], this.getType(), context.getRuleBase().getConfiguration());
    }

    private ObjectTypeNode getObjectTypeNode(BuildContext context) {
        ObjectTypeNode otn = this.getObjectTypeNode();
        return otn != null ? otn : context.getRootObjectTypeNode();
    }

    @Override
    protected void initDeclaredMask(BuildContext context, LeftTupleSource leftInput) {
        if (context == null || context.getLastBuiltPatterns() == null) {
            this.rightDeclaredMask = AllSetBitMask.get();
            super.initDeclaredMask(context, leftInput);
            return;
        }
        Pattern pattern = context.getLastBuiltPatterns()[0];
        this.rightInputIsPassive = pattern.isPassive();
        if (!this.isRightInputIsRiaNode()) {
            ObjectType objectType = pattern.getObjectType();
            if (PropertySpecificUtil.isPropertyReactive(context.getRuleBase(), objectType)) {
                this.rightListenedProperties = pattern.getListenedProperties();
                List<String> accessibleProperties = pattern.getAccessibleProperties(context.getRuleBase());
                this.rightDeclaredMask = pattern.getPositiveWatchMask(accessibleProperties);
                this.rightDeclaredMask = this.rightDeclaredMask.setAll(this.constraints.getListenedPropertyMask(pattern, objectType, accessibleProperties));
                this.rightNegativeMask = pattern.getNegativeWatchMask(accessibleProperties);
            } else {
                this.rightDeclaredMask = AllSetBitMask.get();
            }
        } else {
            this.rightDeclaredMask = AllSetBitMask.get();
            context.setLastBuiltPattern(context.getLastBuiltPatterns()[0]);
        }
        super.initDeclaredMask(context, leftInput);
    }

    @Override
    public void setPartitionId(BuildContext context, RuleBasePartitionId partitionId) {
        if (this.rightInput.getPartitionId() != RuleBasePartitionId.MAIN_PARTITION && !this.rightInput.getPartitionId().equals(partitionId)) {
            this.partitionId = this.rightInput.getPartitionId();
            context.setPartitionId(this.partitionId);
            this.leftInput.setSourcePartitionId(context, this.partitionId);
        } else {
            this.partitionId = partitionId;
        }
    }

    @Override
    protected void setLeftListenedProperties(Collection<String> leftListenedProperties) {
        this.leftListenedProperties = leftListenedProperties;
    }

    public void initInferredMask() {
        this.initInferredMask(this.leftInput);
    }

    @Override
    protected void initInferredMask(LeftTupleSource leftInput) {
        super.initInferredMask(leftInput);
        ObjectSource unwrappedRight = this.unwrapRightInput();
        if (unwrappedRight.getType() == 40) {
            AlphaNode alphaNode = (AlphaNode)unwrappedRight;
            this.rightInferredMask = alphaNode.updateMask(this.rightDeclaredMask);
        } else {
            this.rightInferredMask = this.rightDeclaredMask;
        }
        this.rightInferredMask = this.rightInferredMask.resetAll(this.rightNegativeMask);
    }

    public ObjectSource unwrapRightInput() {
        return this.rightInput;
    }

    private void setUnificationJoin() {
        BetaNodeFieldConstraint[] betaCconstraints = this.constraints.getConstraints();
        if (betaCconstraints.length > 0) {
            BetaNodeFieldConstraint c = betaCconstraints[0];
            if (this.indexable && ((IndexableConstraint)((Object)c)).isUnification()) {
                if (this.constraints instanceof SingleBetaConstraints) {
                    this.setConstraints(new SingleNonIndexSkipBetaConstraints((SingleBetaConstraints)this.constraints));
                } else if (this.constraints instanceof DoubleBetaConstraints) {
                    this.setConstraints(new DoubleNonIndexSkipBetaConstraints((DoubleBetaConstraints)this.constraints));
                } else if (this.constraints instanceof TripleBetaConstraints) {
                    this.setConstraints(new TripleNonIndexSkipBetaConstraints((TripleBetaConstraints)this.constraints));
                } else if (this.constraints instanceof QuadroupleBetaConstraints) {
                    this.setConstraints(new QuadroupleNonIndexSkipBetaConstraints((QuadroupleBetaConstraints)this.constraints));
                }
                this.indexedUnificationJoin = true;
            }
        }
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, ReteEvaluator reteEvaluator) {
        BetaMemory memory = BetaNode.getBetaMemoryFromRightInput(this, reteEvaluator);
        RightTuple rightTuple = this.createRightTuple(factHandle, this, pctx);
        boolean stagedInsertWasEmpty = memory.getStagedRightTuples().addInsert(rightTuple);
        if (isLogTraceEnabled) {
            log.trace("BetaNode stagedInsertWasEmpty={}", (Object)stagedInsertWasEmpty);
        }
        boolean shouldFlush = this.isStreamMode();
        if (memory.getAndIncCounter() == 0) {
            if (stagedInsertWasEmpty) {
                memory.setNodeDirtyWithoutNotify();
            }
            shouldFlush = memory.linkNode(this, reteEvaluator, !this.rightInputIsPassive) | shouldFlush;
        } else if (stagedInsertWasEmpty) {
            shouldFlush = memory.setNodeDirty(this, reteEvaluator, !this.rightInputIsPassive) | shouldFlush;
        }
        if (shouldFlush) {
            TupleEvaluationUtil.flushLeftTupleIfNecessary(reteEvaluator, memory.getOrCreateSegmentMemory(this, reteEvaluator), this.isStreamMode());
        }
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        BetaMemory bm;
        RightTuple rightTuple = modifyPreviousTuples.peekRightTuple(this.partitionId);
        while (rightTuple != null && rightTuple.getInputOtnId().before(this.getRightInputOtnId())) {
            modifyPreviousTuples.removeRightTuple(this.partitionId);
            rightTuple.setPropagationContext(context);
            bm = BetaNode.getBetaMemory((BetaNode)rightTuple.getTupleSink(), reteEvaluator);
            ((BetaNode)rightTuple.getTupleSink()).doDeleteRightTuple(rightTuple, reteEvaluator, bm);
            rightTuple = modifyPreviousTuples.peekRightTuple(this.partitionId);
        }
        if (rightTuple != null && rightTuple.getInputOtnId().equals(this.getRightInputOtnId())) {
            modifyPreviousTuples.removeRightTuple(this.partitionId);
            rightTuple.reAdd();
            if (context.getModificationMask().intersects(this.getRightInferredMask())) {
                rightTuple.setPropagationContext(context);
                bm = BetaNode.getBetaMemory(this, reteEvaluator);
                rightTuple.setPropagationContext(context);
                this.doUpdateRightTuple(rightTuple, reteEvaluator, bm);
            } else if (rightTuple.getMemory() != null) {
                this.reorderRightTuple(reteEvaluator, rightTuple);
            }
        } else if (context.getModificationMask().intersects(this.getRightInferredMask())) {
            this.assertObject(factHandle, context, reteEvaluator);
        }
    }

    protected void reorderRightTuple(ReteEvaluator reteEvaluator, RightTuple rightTuple) {
        BetaNode.getBetaMemory(this, reteEvaluator).getRightTupleMemory().removeAdd(rightTuple);
        RuleNetworkEvaluator.doUpdatesReorderChildLeftTuple(rightTuple);
    }

    public void doDeleteRightTuple(RightTuple rightTuple, ReteEvaluator reteEvaluator, BetaMemory memory) {
        TupleSets<RightTuple> stagedRightTuples = memory.getStagedRightTuples();
        boolean stagedDeleteWasEmpty = stagedRightTuples.addDelete(rightTuple);
        boolean shouldFlush = this.isStreamMode();
        if (memory.getAndDecCounter() == 1) {
            if (stagedDeleteWasEmpty) {
                memory.setNodeDirtyWithoutNotify();
            }
            shouldFlush = memory.unlinkNode(reteEvaluator) | shouldFlush;
        } else if (stagedDeleteWasEmpty) {
            shouldFlush = memory.setNodeDirty(this, reteEvaluator) | shouldFlush;
        }
        if (shouldFlush) {
            TupleEvaluationUtil.flushLeftTupleIfNecessary(reteEvaluator, memory.getOrCreateSegmentMemory(this, reteEvaluator), this.isStreamMode());
        }
    }

    public void doUpdateRightTuple(RightTuple rightTuple, ReteEvaluator reteEvaluator, BetaMemory memory) {
        TupleSets<RightTuple> stagedRightTuples = memory.getStagedRightTuples();
        boolean stagedUpdateWasEmpty = stagedRightTuples.addUpdate(rightTuple);
        boolean shouldFlush = this.isStreamMode();
        if (stagedUpdateWasEmpty) {
            shouldFlush = memory.setNodeDirty(this, reteEvaluator) | shouldFlush;
        }
        if (shouldFlush) {
            TupleEvaluationUtil.flushLeftTupleIfNecessary(reteEvaluator, memory.getOrCreateSegmentMemory(this, reteEvaluator), this.isStreamMode());
        }
    }

    @Override
    public boolean isRightInputIsRiaNode() {
        return this.rightInputIsRiaNode;
    }

    public boolean isRightInputPassive() {
        return this.rightInputIsPassive;
    }

    public ObjectSource getRightInput() {
        return this.rightInput;
    }

    public void setRightInput(ObjectSource rightInput) {
        this.rightInput = rightInput;
        this.rightInputIsRiaNode = 71 == rightInput.getType();
    }

    public FastIterator<Tuple> getRightIterator(TupleMemory memory) {
        if (this.indexedUnificationJoin) {
            return memory.fullFastIterator();
        }
        return memory.fastIterator();
    }

    public RightTuple getFirstRightTuple(Tuple leftTuple, TupleMemory memory, FastIterator<Tuple> it) {
        if (this.indexedUnificationJoin) {
            return it.next(null);
        }
        return (RightTuple)memory.getFirst(leftTuple);
    }

    public FastIterator<Tuple> getLeftIterator(TupleMemory memory) {
        if (this.rightInputIsRiaNode) {
            return FastIterator.NullFastIterator.INSTANCE;
        }
        if (this.indexedUnificationJoin) {
            return memory.fullFastIterator();
        }
        return memory.fastIterator();
    }

    public LeftTuple getFirstLeftTuple(RightTuple rightTuple, TupleMemory memory, FastIterator<Tuple> it) {
        if (this.rightInputIsRiaNode) {
            return this.getStartTuple((SubnetworkTuple)rightTuple);
        }
        if (this.indexedUnificationJoin) {
            return it.next(null);
        }
        return (LeftTuple)memory.getFirst(rightTuple);
    }

    public LeftTuple getStartTuple(LeftTuple lt) {
        LeftTupleSource startTupleSource = ((RightInputAdapterNode)this.getRightInput()).getStartTupleSource();
        while (lt.getIndex() != startTupleSource.getPathIndex() - 1) {
            lt = lt.getLeftParent();
        }
        while (lt.getTupleSink() != this) {
            lt = lt.getPeer();
        }
        return lt;
    }

    public static Tuple getFirstTuple(TupleMemory memory, FastIterator<Tuple> it) {
        if (!memory.isIndexed()) {
            return memory.getFirst(null);
        }
        return it.next(null);
    }

    public boolean isIndexedUnificationJoin() {
        return this.indexedUnificationJoin;
    }

    public BetaNodeFieldConstraint[] getConstraints() {
        return this.constraints.getConstraints();
    }

    public BetaConstraints getRawConstraints() {
        return this.constraints;
    }

    private void setConstraints(BetaConstraints constraints) {
        this.constraints = constraints.cloneIfInUse();
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        updateContext.startVisitNode(this.leftInput);
        this.rightInput.networkUpdated(updateContext);
        updateContext.endVisit();
        if (!updateContext.isVisiting(this.leftInput)) {
            this.leftInput.networkUpdated(updateContext);
        }
    }

    public List<String> getRules() {
        LeftTupleSink[] sinks;
        ArrayList<String> list = new ArrayList<String>();
        for (LeftTupleSink sink1 : sinks = this.sink.getSinks()) {
            if (sink1.getType() == 101) {
                list.add(((RuleTerminalNode)sink1).getRule().getName());
                continue;
            }
            if (!NodeTypeEnums.isBetaNode(sink1)) continue;
            list.addAll(((BetaNode)sink1).getRules());
        }
        return list;
    }

    @Override
    public ObjectTypeNode getObjectTypeNode() {
        if (this.objectTypeNode == null) {
            ObjectSource source = this.rightInput;
            while (source != null) {
                if (source instanceof ObjectTypeNode) {
                    this.objectTypeNode = (ObjectTypeNode)source;
                    break;
                }
                source = source.source;
            }
        }
        return this.objectTypeNode;
    }

    @Override
    public void doAttach(BuildContext context) {
        super.doAttach(context);
        this.setUnificationJoin();
        this.rightInput.addObjectSink(this);
        this.leftInput.addTupleSink(this, context);
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        this.modifyObject(factHandle, modifyPreviousTuples, context, reteEvaluator);
    }

    public static BetaMemory getBetaMemory(BetaNode node, ReteEvaluator reteEvaluator) {
        BetaMemory bm = node.getType() == 211 ? ((AccumulateNode.AccumulateMemory)reteEvaluator.getNodeMemory(node)).getBetaMemory() : (BetaMemory)reteEvaluator.getNodeMemory(node);
        return bm;
    }

    public boolean isObjectMemoryEnabled() {
        return this.objectMemory;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public Memory createMemory(RuleBaseConfiguration config, ReteEvaluator reteEvaluator) {
        return this.constraints.createBetaMemory(config, this.getType());
    }

    @Override
    public String toString() {
        return "[ " + this.getClass().getSimpleName() + "(" + this.id + ") ]";
    }

    protected int calculateHashCode() {
        int hash = 23 * this.leftInput.hashCode() + 29 * this.rightInput.hashCode() + 31 * this.constraints.hashCode();
        if (this.leftListenedProperties != null) {
            hash += 37 * this.leftListenedProperties.hashCode();
        }
        if (this.rightListenedProperties != null) {
            hash += 41 * this.rightListenedProperties.hashCode();
        }
        return hash + (this.rightInputIsPassive ? 43 : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BetaNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        BetaNode other = (BetaNode)object;
        return this.getClass() == other.getClass() && this.constraints.equals(other.constraints) && this.rightInputIsPassive == other.rightInputIsPassive && Objects.equals(this.leftListenedProperties, other.leftListenedProperties) && Objects.equals(this.rightListenedProperties, other.rightListenedProperties) && this.leftInput.getId() == other.leftInput.getId() && this.rightInput.getId() == other.rightInput.getId();
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextObjectSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextObjectSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousObjectSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousObjectSinkNode = previous;
    }

    public RightTuple createRightTuple(InternalFactHandle handle, RightTupleSink sink, PropagationContext context) {
        RightTupleImpl rightTuple = new RightTupleImpl(handle, sink);
        rightTuple.setPropagationContext(context);
        return rightTuple;
    }

    public static BetaMemory getBetaMemoryFromRightInput(BetaNode betaNode, ReteEvaluator reteEvaluator) {
        return 211 == betaNode.getType() ? ((AccumulateNode.AccumulateMemory)reteEvaluator.getNodeMemory(betaNode)).getBetaMemory() : (BetaMemory)reteEvaluator.getNodeMemory(betaNode);
    }

    public BitMask getRightDeclaredMask() {
        return this.rightDeclaredMask;
    }

    public BitMask getRightInferredMask() {
        return this.rightInferredMask;
    }

    void disablePropertyReactivity() {
        this.rightInferredMask = AllSetBitMask.get();
        if (NodeTypeEnums.isBetaNode(this.leftInput)) {
            ((BetaNode)this.leftInput).disablePropertyReactivity();
        }
    }

    public BitMask getRightNegativeMask() {
        return this.rightNegativeMask;
    }

    @Override
    public ObjectTypeNode.Id getRightInputOtnId() {
        return this.rightInputOtnId;
    }

    public void setRightInputOtnId(ObjectTypeNode.Id rightInputOtnId) {
        this.rightInputOtnId = rightInputOtnId;
    }
}

