/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.event.rule.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.rule.Declaration;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.rule.consequence.InternalMatch;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;

public class SerializableActivation
implements Match,
Externalizable {
    private Rule rule;
    private Declaration[] declarations;
    private List<? extends FactHandle> factHandles;
    private PropagationContext propgationContext;
    private boolean active;
    private int salience;

    public SerializableActivation() {
    }

    public SerializableActivation(Match activation) {
        this.rule = activation.getRule();
        this.factHandles = activation.getFactHandles();
        this.propgationContext = ((InternalMatch)activation).getPropagationContext();
        if (activation instanceof RuleTerminalNodeLeftTuple) {
            this.declarations = ((RuleTerminalNode)((RuleTerminalNodeLeftTuple)activation).getTuple().getTupleSink()).getAllDeclarations();
        } else if (activation instanceof SerializableActivation) {
            this.declarations = ((SerializableActivation)activation).declarations;
        } else {
            throw new RuntimeException("Unable to get declarations " + activation);
        }
        this.active = ((InternalMatch)activation).isQueued();
        this.salience = activation.getSalience();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rule = (Rule)in.readObject();
        this.declarations = (Declaration[])in.readObject();
        this.factHandles = (List)in.readObject();
        this.propgationContext = (PropagationContext)in.readObject();
        this.active = in.readBoolean();
        this.salience = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.rule);
        out.writeObject(this.declarations);
        out.writeObject(this.factHandles);
        out.writeObject(this.propgationContext);
        out.writeBoolean(this.active);
        out.writeInt(this.salience);
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public List<? extends FactHandle> getFactHandles() {
        return this.factHandles;
    }

    public PropagationContext getPropagationContext() {
        return this.propgationContext;
    }

    @Override
    public List<Object> getObjects() {
        ArrayList<Object> objects = new ArrayList<Object>(this.factHandles.size());
        for (FactHandle factHandle : this.factHandles) {
            objects.add(((InternalFactHandle)factHandle).getObject());
        }
        return Collections.unmodifiableList(objects);
    }

    @Override
    public Object getDeclarationValue(String variableName) {
        Declaration decl = ((RuleImpl)this.rule).getDeclaration(variableName);
        return decl.getValue(null, ((InternalFactHandle)this.factHandles.get(decl.getObjectIndex())).getObject());
    }

    @Override
    public List<String> getDeclarationIds() {
        ArrayList<String> decls = new ArrayList<String>();
        for (Declaration decl : this.declarations) {
            decls.add(decl.getIdentifier());
        }
        return Collections.unmodifiableList(decls);
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public int getSalience() {
        return this.salience;
    }
}

