/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.drools.base.factmodel.traits.TraitTypeEnum;
import org.drools.base.rule.EntryPointId;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.Tuple;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.util.StringUtils;

@XmlRootElement(name="fact-handle")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultFactHandle
extends AbstractBaseLinkedListNode<DefaultFactHandle>
implements InternalFactHandle {
    private static final long serialVersionUID = 510L;
    static final String FACT_FORMAT_VERSION = "0";
    protected long id;
    protected long recency;
    protected Object object;
    private EqualityKey key;
    protected int objectHashCode;
    protected int identityHashCode;
    protected EntryPointId entryPointId;
    private boolean disconnected;
    private boolean valid = true;
    private boolean negated;
    protected String objectClassName;
    protected InternalFactHandle.LinkedTuples linkedTuples;
    protected transient WorkingMemoryEntryPoint wmEntryPoint;

    public DefaultFactHandle() {
    }

    public DefaultFactHandle(Object object) {
        this.object = object;
    }

    public DefaultFactHandle(long id, Object object) {
        this(id, object, id, null);
    }

    public DefaultFactHandle(long id, Object object, long recency, WorkingMemoryEntryPoint wmEntryPoint) {
        this(id, DefaultFactHandle.determineIdentityHashCode(object), object, recency, wmEntryPoint);
    }

    public DefaultFactHandle(long id, int identityHashCode, Object object, long recency, WorkingMemoryEntryPoint wmEntryPoint) {
        this(id, identityHashCode, object, recency, wmEntryPoint == null ? null : wmEntryPoint.getEntryPoint());
        if (wmEntryPoint != null) {
            this.setLinkedTuples(wmEntryPoint.getKnowledgeBase());
            this.wmEntryPoint = wmEntryPoint;
        } else {
            this.linkedTuples = new SingleLinkedTuples();
        }
    }

    protected DefaultFactHandle(long id, int identityHashCode, Object object, long recency, EntryPointId entryPointId) {
        this.id = id;
        this.entryPointId = entryPointId;
        this.recency = recency;
        this.setObject(object);
        this.identityHashCode = identityHashCode;
    }

    public DefaultFactHandle(long id, String wmEntryPointId, int identityHashCode, int objectHashCode, long recency, Object object) {
        this.id = id;
        this.entryPointId = new EntryPointId(wmEntryPointId);
        this.recency = recency;
        this.setObject(object);
        this.identityHashCode = identityHashCode;
        this.objectHashCode = objectHashCode;
        this.disconnected = true;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DefaultFactHandle && this.id == ((DefaultFactHandle)object).id;
    }

    @Override
    public void disconnect() {
        this.key = null;
        this.linkedTuples = null;
        this.entryPointId = null;
        this.disconnected = true;
    }

    @Override
    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    @Override
    public <K> K as(Class<K> klass) throws ClassCastException {
        if (klass.isAssignableFrom(this.object.getClass())) {
            return (K)this.object;
        }
        throw new ClassCastException("The Handle's Object can't be cast to " + klass);
    }

    @Override
    public boolean isDisconnected() {
        return this.disconnected;
    }

    @Override
    public void setDisconnected(boolean disconnected) {
        this.disconnected = disconnected;
    }

    @Override
    public int getObjectHashCode() {
        if (this.objectHashCode == 0 && this.object != null) {
            this.objectHashCode = this.object.hashCode();
        }
        return this.objectHashCode;
    }

    @Override
    public int getIdentityHashCode() {
        if (this.identityHashCode == 0 && this.object != null) {
            this.identityHashCode = DefaultFactHandle.determineIdentityHashCode(this.object);
        }
        return this.identityHashCode;
    }

    public static int determineIdentityHashCode(Object object) {
        return System.identityHashCode(object);
    }

    protected void setIdentityHashCode(int identityHashCode) {
        this.identityHashCode = identityHashCode;
    }

    protected void setObjectHashCode(int hashCode) {
        this.objectHashCode = hashCode;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    @Override
    public final String toExternalForm() {
        return this.getFormatVersion() + ":" + this.id + ":" + this.getIdentityHashCode() + ":" + this.getObjectHashCode() + ":" + this.getRecency() + ":" + (this.entryPointId != null ? this.entryPointId.getEntryPointId() : "null") + ":" + this.getTraitType().name() + ":" + this.getObjectClassName();
    }

    protected String getFormatVersion() {
        return FACT_FORMAT_VERSION;
    }

    @XmlAttribute(name="external-form")
    public String getExternalForm() {
        return this.toExternalForm();
    }

    public void setExternalForm(String externalForm) {
        DefaultFactHandle.populateFactHandleFromExternalForm(externalForm, this);
    }

    public String toString() {
        return "[fact " + this.toExternalForm() + ":" + this.object + "]";
    }

    @Override
    public long getRecency() {
        return this.recency;
    }

    @Override
    public void setRecency(long recency) {
        this.recency = recency;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void invalidate() {
        this.valid = false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public String getObjectClassName() {
        if (this.object != null) {
            this.objectClassName = this.object.getClass().getName();
        }
        return this.objectClassName;
    }

    @Override
    public void setObject(Object object) {
        this.object = object;
        this.objectClassName = null;
        this.objectHashCode = 0;
        this.identityHashCode = 0;
    }

    @Override
    public EqualityKey getEqualityKey() {
        return this.key;
    }

    @Override
    public void setEqualityKey(EqualityKey key) {
        this.key = key;
    }

    @Override
    public boolean isEvent() {
        return false;
    }

    @Override
    public boolean isTraitOrTraitable() {
        return false;
    }

    @Override
    public boolean isTraitable() {
        return false;
    }

    @Override
    public boolean isTraiting() {
        return false;
    }

    @Override
    public TraitTypeEnum getTraitType() {
        return TraitTypeEnum.NON_TRAIT;
    }

    protected void setTraitType(TraitTypeEnum traitType) {
    }

    @Override
    public ReteEvaluator getReteEvaluator() {
        return this.wmEntryPoint.getReteEvaluator();
    }

    @Override
    public EntryPointId getEntryPointId() {
        return this.entryPointId;
    }

    @Override
    public WorkingMemoryEntryPoint getEntryPoint(ReteEvaluator reteEvaluator) {
        if (this.wmEntryPoint == null) {
            this.wmEntryPoint = reteEvaluator.getEntryPoint(this.entryPointId.getEntryPointId());
        }
        return this.wmEntryPoint;
    }

    protected void setLinkedTuples(InternalRuleBase kbase) {
        this.linkedTuples = kbase != null && kbase.isPartitioned() ? new CompositeLinkedTuples(kbase.getParallelEvaluationSlotsCount()) : new SingleLinkedTuples();
    }

    @Override
    public void addFirstLeftTuple(LeftTuple leftTuple) {
        this.linkedTuples.addFirstLeftTuple(leftTuple);
    }

    @Override
    public void addLastLeftTuple(LeftTuple leftTuple) {
        this.linkedTuples.addLastLeftTuple(leftTuple);
    }

    @Override
    public void addTupleInPosition(Tuple tuple) {
        this.linkedTuples.addTupleInPosition(tuple);
    }

    @Override
    public void removeLeftTuple(LeftTuple leftTuple) {
        this.linkedTuples.removeLeftTuple(leftTuple);
    }

    @Override
    public void addLastRightTuple(RightTuple rightTuple) {
        this.linkedTuples.addLastRightTuple(rightTuple);
    }

    @Override
    public void removeRightTuple(RightTuple rightTuple) {
        this.linkedTuples.removeRightTuple(rightTuple);
    }

    @Override
    public void clearLeftTuples() {
        this.linkedTuples.clearLeftTuples();
    }

    @Override
    public void clearRightTuples() {
        this.linkedTuples.clearRightTuples();
    }

    @Override
    public DefaultFactHandle clone() {
        DefaultFactHandle clone = new DefaultFactHandle(this.id, this.identityHashCode, this.object, this.recency, this.entryPointId);
        clone.key = this.key;
        clone.linkedTuples = this.linkedTuples.clone();
        clone.objectHashCode = this.objectHashCode;
        clone.disconnected = this.disconnected;
        clone.negated = this.negated;
        clone.wmEntryPoint = this.wmEntryPoint;
        return clone;
    }

    public static DefaultFactHandle createFromExternalFormat(String externalFormat) {
        DefaultFactHandle handle;
        String[] elements = DefaultFactHandle.splitExternalForm(externalFormat);
        if (FACT_FORMAT_VERSION.equals(elements[0])) {
            handle = new DefaultFactHandle();
        } else if ("5".equals(elements[0])) {
            handle = new DefaultEventHandle();
        } else {
            throw new RuntimeException("Unknown fact handle version format: " + elements[0]);
        }
        DefaultFactHandle.populateFactHandleFromExternalForm(elements, handle);
        return handle;
    }

    private static String[] splitExternalForm(String externalFormat) {
        String[] elements = externalFormat.split(":");
        if (elements.length < 6) {
            throw new IllegalArgumentException("externalFormat did not have enough elements [" + externalFormat + "]");
        }
        return elements;
    }

    private static void populateFactHandleFromExternalForm(String externalFormat, DefaultFactHandle handle) {
        DefaultFactHandle.populateFactHandleFromExternalForm(DefaultFactHandle.splitExternalForm(externalFormat), handle);
    }

    private static void populateFactHandleFromExternalForm(String[] elements, DefaultFactHandle handle) {
        handle.id = Long.parseLong(elements[1]);
        handle.identityHashCode = Integer.parseInt(elements[2]);
        handle.objectHashCode = Integer.parseInt(elements[3]);
        handle.recency = Long.parseLong(elements[4]);
        handle.entryPointId = StringUtils.isEmpty(elements[5]) || "null".equals(elements[5].trim()) ? null : new EntryPointId(elements[5].trim());
        handle.disconnected = true;
        handle.setTraitType(elements.length > 6 ? TraitTypeEnum.valueOf(elements[6]) : TraitTypeEnum.NON_TRAIT);
        handle.objectClassName = elements.length > 7 ? elements[7] : null;
    }

    @Override
    public boolean isExpired() {
        return false;
    }

    @Override
    public boolean isPendingRemoveFromStore() {
        return false;
    }

    @Override
    public void forEachRightTuple(Consumer<RightTuple> rightTupleConsumer) {
        this.linkedTuples.forEachRightTuple(rightTupleConsumer);
    }

    @Override
    public void forEachLeftTuple(Consumer<LeftTuple> leftTupleConsumer) {
        this.linkedTuples.forEachLeftTuple(leftTupleConsumer);
    }

    @Override
    public LeftTuple findFirstLeftTuple(Predicate<LeftTuple> lefttTuplePredicate) {
        return this.linkedTuples.findFirstLeftTuple(lefttTuplePredicate);
    }

    @Override
    public LeftTuple getFirstLeftTuple() {
        if (this.linkedTuples instanceof SingleLinkedTuples) {
            return ((SingleLinkedTuples)this.linkedTuples).getFirstLeftTuple();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public RightTuple getFirstRightTuple() {
        if (this.linkedTuples instanceof SingleLinkedTuples) {
            return ((SingleLinkedTuples)this.linkedTuples).getFirstRightTuple();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public InternalFactHandle.LinkedTuples getLinkedTuples() {
        return this.linkedTuples;
    }

    @Override
    public InternalFactHandle.LinkedTuples detachLinkedTuples() {
        InternalFactHandle.LinkedTuples detached = this.linkedTuples;
        this.linkedTuples = new SingleLinkedTuples();
        return detached;
    }

    @Override
    public InternalFactHandle.LinkedTuples detachLinkedTuplesForPartition(int i) {
        InternalFactHandle.LinkedTuples detached = ((CompositeLinkedTuples)this.linkedTuples).getPartitionedTuple(i);
        ((CompositeLinkedTuples)this.linkedTuples).partitionedTuples[i] = null;
        return detached;
    }

    public static class SingleLinkedTuples
    implements InternalFactHandle.LinkedTuples {
        private RightTuple firstRightTuple;
        private RightTuple lastRightTuple;
        private LeftTuple firstLeftTuple;
        private LeftTuple lastLeftTuple;

        @Override
        public SingleLinkedTuples clone() {
            SingleLinkedTuples clone = new SingleLinkedTuples();
            clone.firstLeftTuple = this.firstLeftTuple;
            clone.lastLeftTuple = this.lastLeftTuple;
            clone.firstRightTuple = this.firstRightTuple;
            clone.lastRightTuple = this.lastRightTuple;
            return clone;
        }

        @Override
        public InternalFactHandle.LinkedTuples cloneEmpty() {
            return new SingleLinkedTuples();
        }

        @Override
        public boolean hasTuples() {
            return this.firstLeftTuple != null || this.firstRightTuple != null;
        }

        @Override
        public void addFirstLeftTuple(LeftTuple leftTuple) {
            LeftTuple previous = this.firstLeftTuple;
            leftTuple.setHandlePrevious(null);
            if (previous == null) {
                leftTuple.setHandleNext(null);
                this.firstLeftTuple = leftTuple;
                this.lastLeftTuple = leftTuple;
            } else {
                leftTuple.setHandleNext(previous);
                previous.setHandlePrevious(leftTuple);
                this.firstLeftTuple = leftTuple;
            }
        }

        @Override
        public void addLastLeftTuple(LeftTuple leftTuple) {
            LeftTuple previous = this.lastLeftTuple;
            if (previous == null) {
                leftTuple.setHandlePrevious(null);
                leftTuple.setHandleNext(null);
                this.firstLeftTuple = leftTuple;
            } else {
                leftTuple.setHandlePrevious(previous);
                leftTuple.setHandleNext(null);
                previous.setHandleNext(leftTuple);
            }
            this.lastLeftTuple = leftTuple;
        }

        @Override
        public void addTupleInPosition(Tuple tuple) {
            Tuple previous;
            boolean left = tuple instanceof LeftTuple;
            ObjectTypeNode.Id otnId = tuple.getInputOtnId();
            if (otnId == null) {
                this.addLastTuple(tuple, left);
                return;
            }
            Tuple tuple2 = previous = left ? this.lastLeftTuple : this.lastRightTuple;
            if (previous == null) {
                tuple.setHandlePrevious(null);
                tuple.setHandleNext(null);
                this.setFirstTuple(tuple, left);
                this.setLastTuple(tuple, left);
                return;
            }
            if (previous.getTupleSink() == null || !otnId.before(previous.getInputOtnId())) {
                tuple.setHandlePrevious(previous);
                tuple.setHandleNext(null);
                previous.setHandleNext(tuple);
                this.setLastTuple(tuple, left);
                return;
            }
            Tuple next = previous;
            for (previous = previous.getHandlePrevious(); previous != null && otnId.before(previous.getInputOtnId()); previous = previous.getHandlePrevious()) {
                next = previous;
            }
            tuple.setHandleNext(next);
            next.setHandlePrevious(tuple);
            tuple.setHandlePrevious(previous);
            if (previous != null) {
                previous.setHandleNext(tuple);
            } else {
                this.setFirstTuple(tuple, left);
            }
        }

        private void addLastTuple(Tuple tuple, boolean left) {
            if (left) {
                this.addLastLeftTuple((LeftTuple)tuple);
            } else {
                this.addLastRightTuple((RightTuple)tuple);
            }
        }

        private void setFirstTuple(Tuple tuple, boolean left) {
            if (left) {
                this.firstLeftTuple = (LeftTuple)tuple;
            } else {
                this.firstRightTuple = (RightTuple)tuple;
            }
        }

        private void setLastTuple(Tuple tuple, boolean left) {
            if (left) {
                this.lastLeftTuple = (LeftTuple)tuple;
            } else {
                this.lastRightTuple = (RightTuple)tuple;
            }
        }

        @Override
        public void removeLeftTuple(LeftTuple leftTuple) {
            LeftTuple previous = leftTuple.getHandlePrevious();
            LeftTuple next = leftTuple.getHandleNext();
            if (previous != null && next != null) {
                previous.setHandleNext(next);
                next.setHandlePrevious(previous);
            } else if (next != null) {
                next.setHandlePrevious(null);
                this.firstLeftTuple = next;
            } else if (previous != null) {
                previous.setHandleNext(null);
                this.lastLeftTuple = previous;
            } else {
                this.firstLeftTuple = null;
                this.lastLeftTuple = null;
            }
            leftTuple.setHandlePrevious(null);
            leftTuple.setHandleNext(null);
        }

        @Override
        public void addFirstRightTuple(RightTuple rightTuple) {
            RightTuple previousFirst = this.firstRightTuple;
            this.firstRightTuple = rightTuple;
            rightTuple.setHandlePrevious(null);
            if (previousFirst == null) {
                rightTuple.setHandleNext(null);
                this.lastRightTuple = rightTuple;
            } else {
                rightTuple.setHandleNext(previousFirst);
                previousFirst.setHandlePrevious(rightTuple);
            }
        }

        @Override
        public void addLastRightTuple(RightTuple rightTuple) {
            RightTuple previousLast = this.lastRightTuple;
            if (previousLast == null) {
                rightTuple.setHandlePrevious(null);
                rightTuple.setHandleNext(null);
                this.firstRightTuple = rightTuple;
            } else {
                rightTuple.setHandlePrevious(previousLast);
                rightTuple.setHandleNext(null);
                previousLast.setHandleNext(rightTuple);
            }
            this.lastRightTuple = rightTuple;
        }

        @Override
        public void removeRightTuple(RightTuple rightTuple) {
            RightTuple previous = (RightTuple)rightTuple.getHandlePrevious();
            RightTuple next = (RightTuple)rightTuple.getHandleNext();
            if (previous != null && next != null) {
                previous.setHandleNext(next);
                next.setHandlePrevious(previous);
            } else if (next != null) {
                next.setHandlePrevious(null);
                this.firstRightTuple = next;
            } else if (previous != null) {
                previous.setHandleNext(null);
                this.lastRightTuple = previous;
            } else {
                this.firstRightTuple = null;
                this.lastRightTuple = null;
            }
            rightTuple.setHandlePrevious(null);
            rightTuple.setHandleNext(null);
        }

        @Override
        public void clearLeftTuples() {
            this.firstLeftTuple = null;
            this.lastLeftTuple = null;
        }

        @Override
        public void clearRightTuples() {
            this.firstRightTuple = null;
            this.lastRightTuple = null;
        }

        @Override
        public void forEachRightTuple(Consumer<RightTuple> rightTupleConsumer) {
            RightTuple rightTuple = this.firstRightTuple;
            while (rightTuple != null) {
                RightTuple nextRightTuple = (RightTuple)rightTuple.getHandleNext();
                rightTupleConsumer.accept(rightTuple);
                rightTuple = nextRightTuple;
            }
        }

        @Override
        public void forEachLeftTuple(Consumer<LeftTuple> leftTupleConsumer) {
            LeftTuple leftTuple = this.firstLeftTuple;
            while (leftTuple != null) {
                LeftTuple nextLeftTuple = leftTuple.getHandleNext();
                leftTupleConsumer.accept(leftTuple);
                leftTuple = nextLeftTuple;
            }
        }

        @Override
        public LeftTuple findFirstLeftTuple(Predicate<LeftTuple> lefttTuplePredicate) {
            LeftTuple leftTuple = this.firstLeftTuple;
            while (leftTuple != null) {
                LeftTuple nextLeftTuple = leftTuple.getHandleNext();
                if (lefttTuplePredicate.test(leftTuple)) {
                    return leftTuple;
                }
                leftTuple = nextLeftTuple;
            }
            return null;
        }

        @Override
        public LeftTuple getFirstLeftTuple(int partition) {
            return this.getFirstLeftTuple();
        }

        LeftTuple getFirstLeftTuple() {
            return this.firstLeftTuple;
        }

        @Override
        public RightTuple getFirstRightTuple(int partition) {
            return this.getFirstRightTuple();
        }

        RightTuple getFirstRightTuple() {
            return this.firstRightTuple;
        }
    }

    public static class CompositeLinkedTuples
    implements InternalFactHandle.LinkedTuples {
        private final InternalFactHandle.LinkedTuples[] partitionedTuples;

        public CompositeLinkedTuples(int parallelEvaluationSlotsCount) {
            this.partitionedTuples = new InternalFactHandle.LinkedTuples[parallelEvaluationSlotsCount];
        }

        private InternalFactHandle.LinkedTuples getPartitionedTuple(int partition) {
            InternalFactHandle.LinkedTuples tuples = this.partitionedTuples[partition];
            return tuples != null ? tuples : DummyLinkedTuples.INSTANCE;
        }

        private InternalFactHandle.LinkedTuples getOrCreatePartitionedTuple(int partition) {
            InternalFactHandle.LinkedTuples tuples = this.partitionedTuples[partition];
            if (tuples == null) {
                tuples = this.partitionedTuples[partition] = new SingleLinkedTuples();
            }
            return tuples;
        }

        @Override
        public InternalFactHandle.LinkedTuples cloneEmpty() {
            return new CompositeLinkedTuples(this.partitionedTuples.length);
        }

        @Override
        public boolean hasTuples() {
            for (int i = 0; i < this.partitionedTuples.length; ++i) {
                if (!this.getPartitionedTuple(i).hasTuples()) continue;
                return true;
            }
            return false;
        }

        @Override
        public InternalFactHandle.LinkedTuples clone() {
            CompositeLinkedTuples clone = new CompositeLinkedTuples(this.partitionedTuples.length);
            for (int i = 0; i < this.partitionedTuples.length; ++i) {
                clone.partitionedTuples[i] = this.partitionedTuples[i] == null ? null : this.partitionedTuples[i].clone();
            }
            return clone;
        }

        private InternalFactHandle.LinkedTuples getPartitionedTuple(Tuple tuple) {
            return this.getPartitionedTuple(tuple.getTupleSink().getPartitionId().getParallelEvaluationSlot());
        }

        private InternalFactHandle.LinkedTuples getOrCreatePartitionedTuple(Tuple tuple) {
            return this.getOrCreatePartitionedTuple(tuple.getTupleSink().getPartitionId().getParallelEvaluationSlot());
        }

        @Override
        public void addFirstLeftTuple(LeftTuple leftTuple) {
            this.getOrCreatePartitionedTuple(leftTuple).addFirstLeftTuple(leftTuple);
        }

        @Override
        public void addLastLeftTuple(LeftTuple leftTuple) {
            this.getOrCreatePartitionedTuple(leftTuple).addLastLeftTuple(leftTuple);
        }

        @Override
        public void addTupleInPosition(Tuple tuple) {
            this.getOrCreatePartitionedTuple(tuple).addTupleInPosition(tuple);
        }

        @Override
        public void removeLeftTuple(LeftTuple leftTuple) {
            this.getPartitionedTuple(leftTuple).removeLeftTuple(leftTuple);
        }

        @Override
        public void addFirstRightTuple(RightTuple rightTuple) {
            this.getOrCreatePartitionedTuple(rightTuple).addFirstRightTuple(rightTuple);
        }

        @Override
        public void addLastRightTuple(RightTuple rightTuple) {
            this.getOrCreatePartitionedTuple(rightTuple).addLastRightTuple(rightTuple);
        }

        @Override
        public void removeRightTuple(RightTuple rightTuple) {
            if (rightTuple.getTupleSink() != null) {
                this.getPartitionedTuple(rightTuple).removeRightTuple(rightTuple);
            }
        }

        @Override
        public void clearLeftTuples() {
            for (int i = 0; i < this.partitionedTuples.length; ++i) {
                this.clearLeftTuples(i);
            }
        }

        public void clearLeftTuples(int partition) {
            this.getPartitionedTuple(partition).clearLeftTuples();
        }

        @Override
        public void clearRightTuples() {
            for (int i = 0; i < this.partitionedTuples.length; ++i) {
                this.clearRightTuples(i);
            }
        }

        public void clearRightTuples(int partition) {
            this.getPartitionedTuple(partition).clearRightTuples();
        }

        @Override
        public void forEachRightTuple(Consumer<RightTuple> rightTupleConsumer) {
            for (int i = 0; i < this.partitionedTuples.length; ++i) {
                this.forEachRightTuple(i, rightTupleConsumer);
            }
        }

        public void forEachRightTuple(int partition, Consumer<RightTuple> rightTupleConsumer) {
            this.getPartitionedTuple(partition).forEachRightTuple(rightTupleConsumer);
        }

        @Override
        public void forEachLeftTuple(Consumer<LeftTuple> leftTupleConsumer) {
            for (int i = 0; i < this.partitionedTuples.length; ++i) {
                this.forEachLeftTuple(i, leftTupleConsumer);
            }
        }

        public void forEachLeftTuple(int partition, Consumer<LeftTuple> leftTupleConsumer) {
            this.getPartitionedTuple(partition).forEachLeftTuple(leftTupleConsumer);
        }

        @Override
        public LeftTuple findFirstLeftTuple(Predicate<LeftTuple> lefttTuplePredicate) {
            return Stream.of(this.partitionedTuples).map(t -> t.findFirstLeftTuple(lefttTuplePredicate)).filter(Objects::nonNull).findFirst().orElse(null);
        }

        @Override
        public LeftTuple getFirstLeftTuple(int partition) {
            return ((SingleLinkedTuples)this.partitionedTuples[partition]).getFirstLeftTuple();
        }

        @Override
        public RightTuple getFirstRightTuple(int partition) {
            return ((SingleLinkedTuples)this.partitionedTuples[partition]).getFirstRightTuple();
        }
    }

    public static class DummyLinkedTuples
    implements InternalFactHandle.LinkedTuples {
        private static final DummyLinkedTuples INSTANCE = new DummyLinkedTuples();

        @Override
        public InternalFactHandle.LinkedTuples clone() {
            return this;
        }

        @Override
        public InternalFactHandle.LinkedTuples cloneEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasTuples() {
            return false;
        }

        @Override
        public void addFirstLeftTuple(LeftTuple leftTuple) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addLastLeftTuple(LeftTuple leftTuple) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addTupleInPosition(Tuple tuple) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeLeftTuple(LeftTuple leftTuple) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addFirstRightTuple(RightTuple rightTuple) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addLastRightTuple(RightTuple rightTuple) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeRightTuple(RightTuple rightTuple) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearLeftTuples() {
        }

        @Override
        public void clearRightTuples() {
        }

        @Override
        public void forEachRightTuple(Consumer<RightTuple> rightTupleConsumer) {
        }

        @Override
        public void forEachLeftTuple(Consumer<LeftTuple> leftTupleConsumer) {
        }

        @Override
        public LeftTuple findFirstLeftTuple(Predicate<LeftTuple> leftTuplePredicate) {
            return null;
        }

        @Override
        public LeftTuple getFirstLeftTuple(int partition) {
            return null;
        }

        @Override
        public RightTuple getFirstRightTuple(int partition) {
            return null;
        }
    }
}

