/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.rule;

import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.rule.RuleConstructionException;

public class DuplicateRuleNameException
extends RuleConstructionException {
    private static final long serialVersionUID = 510L;
    private Package pkg;
    private RuleImpl originalRule;
    private RuleImpl conflictingRule;

    public DuplicateRuleNameException(Package pkg, RuleImpl originalRule, RuleImpl conflictingRule) {
        super(DuplicateRuleNameException.createMessage(pkg, conflictingRule));
        this.pkg = pkg;
        this.originalRule = originalRule;
        this.conflictingRule = conflictingRule;
    }

    public DuplicateRuleNameException(Package pkg, RuleImpl originalRule, RuleImpl conflictingRule, Throwable cause) {
        super(DuplicateRuleNameException.createMessage(pkg, conflictingRule), cause);
        this.pkg = pkg;
        this.originalRule = originalRule;
        this.conflictingRule = conflictingRule;
    }

    public Package getPackage() {
        return this.pkg;
    }

    public RuleImpl getOriginalRule() {
        return this.originalRule;
    }

    public RuleImpl getConflictingRule() {
        return this.conflictingRule;
    }

    private static String createMessage(Package pkg, RuleImpl rule) {
        return "Package " + (pkg.getName() != null ? pkg.getName() : "<no-name>") + " already contains rule with name " + rule.getName();
    }
}

