/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.base.reteoo.NodeTypeEnums;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.PhreakRuleTerminalNode;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.ConditionalBranchEvaluator;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;

public class PhreakBranchNode {
    public void doNode(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, LeftTupleSink sink, ActivationsManager activationsManager, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples, RuleExecutor executor) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(sink, activationsManager, srcLeftTuples, trgLeftTuples, stagedLeftTuples, executor);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(branchNode, cbm, sink, activationsManager, srcLeftTuples, trgLeftTuples, stagedLeftTuples, executor);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(branchNode, cbm, sink, activationsManager, srcLeftTuples, trgLeftTuples, executor);
        }
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, LeftTupleSink sink, ActivationsManager activationsManager, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, RuleExecutor executor) {
        ConditionalBranchEvaluator branchEvaluator = branchNode.getBranchEvaluator();
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            boolean breaking = false;
            ConditionalBranchEvaluator.ConditionalExecution conditionalExecution = branchEvaluator.evaluate(leftTuple, activationsManager.getReteEvaluator(), cbm.context);
            boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(branchNode, leftTuple);
            if (conditionalExecution != null) {
                RuleTerminalNode rtn = (RuleTerminalNode)conditionalExecution.getSink().getFirstLeftTupleSink();
                RuleTerminalNodeLeftTuple branchedLeftTuple = (RuleTerminalNodeLeftTuple)rtn.createLeftTuple(leftTuple, rtn, leftTuple.getPropagationContext(), useLeftMemory);
                PhreakRuleTerminalNode.doLeftTupleInsert(rtn, executor, activationsManager, executor.getRuleAgendaItem(), branchedLeftTuple);
                breaking = conditionalExecution.isBreaking();
            }
            if (!breaking) {
                trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), useLeftMemory));
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftUpdates(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, LeftTupleSink sink, ActivationsManager activationsManager, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples, RuleExecutor executor) {
        ConditionalBranchEvaluator branchEvaluator = branchNode.getBranchEvaluator();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            BranchTuples branchTuples = this.getBranchTuples(sink, leftTuple);
            RuleTerminalNode oldRtn = null;
            if (branchTuples.rtnLeftTuple != null) {
                oldRtn = (RuleTerminalNode)branchTuples.rtnLeftTuple.getTupleSink();
            }
            ConditionalBranchEvaluator.ConditionalExecution conditionalExecution = branchEvaluator.evaluate(leftTuple, activationsManager.getReteEvaluator(), cbm.context);
            RuleTerminalNode newRtn = null;
            boolean breaking = false;
            if (conditionalExecution != null) {
                newRtn = (RuleTerminalNode)conditionalExecution.getSink().getFirstLeftTupleSink();
                breaking = conditionalExecution.isBreaking();
            }
            if (oldRtn != null) {
                if (newRtn == null) {
                    if (branchTuples.rtnLeftTuple.getMemory() != null) {
                        executor.removeActiveTuple(branchTuples.rtnLeftTuple);
                    }
                    PhreakRuleTerminalNode.doLeftDelete(activationsManager, executor, branchTuples.rtnLeftTuple);
                } else if (newRtn == oldRtn) {
                    PhreakRuleTerminalNode.doLeftTupleUpdate(newRtn, executor, activationsManager, branchTuples.rtnLeftTuple);
                } else {
                    if (branchTuples.rtnLeftTuple.getMemory() != null) {
                        executor.removeActiveTuple(branchTuples.rtnLeftTuple);
                    }
                    PhreakRuleTerminalNode.doLeftDelete(activationsManager, executor, branchTuples.rtnLeftTuple);
                    branchTuples.rtnLeftTuple = (RuleTerminalNodeLeftTuple)newRtn.createLeftTuple(leftTuple, newRtn, leftTuple.getPropagationContext(), true);
                    PhreakRuleTerminalNode.doLeftTupleInsert(newRtn, executor, activationsManager, executor.getRuleAgendaItem(), branchTuples.rtnLeftTuple);
                }
            } else if (newRtn != null) {
                branchTuples.rtnLeftTuple = (RuleTerminalNodeLeftTuple)newRtn.createLeftTuple(leftTuple, newRtn, leftTuple.getPropagationContext(), true);
                PhreakRuleTerminalNode.doLeftTupleInsert(newRtn, executor, activationsManager, executor.getRuleAgendaItem(), branchTuples.rtnLeftTuple);
            }
            if (branchTuples.mainLeftTuple != null) {
                RuleNetworkEvaluator.normalizeStagedTuples(stagedLeftTuples, branchTuples.mainLeftTuple);
                if (breaking && !NodeTypeEnums.isTerminalNode(branchTuples.mainLeftTuple.getTupleSink())) {
                    trgLeftTuples.addDelete(branchTuples.mainLeftTuple);
                } else {
                    trgLeftTuples.addUpdate(branchTuples.mainLeftTuple);
                }
            } else if (!breaking) {
                trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), true));
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftDeletes(LeftTupleSink sink, ActivationsManager activationsManager, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples, RuleExecutor executor) {
        LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            BranchTuples branchTuples = this.getBranchTuples(sink, leftTuple);
            if (branchTuples.rtnLeftTuple != null) {
                if (branchTuples.rtnLeftTuple.getMemory() != null) {
                    executor.removeActiveTuple(branchTuples.rtnLeftTuple);
                }
                PhreakRuleTerminalNode.doLeftDelete(activationsManager, executor, branchTuples.rtnLeftTuple);
            }
            if (branchTuples.mainLeftTuple != null) {
                RuleNetworkEvaluator.deleteChildLeftTuple(branchTuples.mainLeftTuple, trgLeftTuples, stagedLeftTuples);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    private BranchTuples getBranchTuples(LeftTupleSink sink, LeftTuple leftTuple) {
        BranchTuples branchTuples = new BranchTuples();
        LeftTuple child = leftTuple.getFirstChild();
        if (child != null) {
            if (child.getTupleSink() == sink) {
                branchTuples.mainLeftTuple = child;
            } else {
                branchTuples.rtnLeftTuple = (RuleTerminalNodeLeftTuple)child;
            }
            child = child.getHandleNext();
            if (child != null) {
                if (child.getTupleSink() == sink) {
                    branchTuples.mainLeftTuple = child;
                } else {
                    branchTuples.rtnLeftTuple = (RuleTerminalNodeLeftTuple)child;
                }
            }
        }
        return branchTuples;
    }

    private static class BranchTuples {
        RuleTerminalNodeLeftTuple rtnLeftTuple;
        LeftTuple mainLeftTuple;

        private BranchTuples() {
        }
    }
}

