/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drlonyaml.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.Callable;
import org.drools.drlonyaml.cli.utils.Utils;
import org.drools.drlonyaml.model.DrlPackage;
import org.drools.drlonyaml.todrl.YAMLtoDrlDumper;
import org.drools.util.IoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="yaml2drl", description={"Converts a single .yml file to DRL format."})
public class Yaml2Drl
implements Callable<Integer> {
    @CommandLine.Option(names={"-o", "--output"}, paramLabel="OUTPUT_FILE", description={"The output file to write the content of the conversion to. If left empty, the translated format will be emitted on STDOUT."})
    private File archive;
    @CommandLine.Parameters(index="0", paramLabel="INPUT_FILE", description={"The .yml file to be converted in YAML format. If left empty, content will be read from STDIN."}, arity="0..1")
    private File inputFile;
    private InputStream inputStream;
    private static final ObjectMapper mapper;

    @Override
    public Integer call() throws Exception {
        this.inputStream = Utils.conventionInputStream(this.inputFile);
        String content = new String(IoUtils.readBytesFromInputStream(this.inputStream));
        String drlText = Yaml2Drl.yaml2drl(content);
        Utils.conventionOutputConsumer(this.archive).accept(drlText);
        return 0;
    }

    public static String yaml2drl(String yaml) throws Exception {
        DrlPackage readValue = mapper.readValue(yaml, DrlPackage.class);
        String drlText = YAMLtoDrlDumper.dumpDRL(readValue);
        return drlText;
    }

    static {
        YAMLFactory yamlFactory = YAMLFactory.builder().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).build();
        mapper = new ObjectMapper(yamlFactory);
    }
}

